function showHelp(){
  var win = window.open('root/help.html', '_blank');
  win.focus();
};

function init_View(div, model, port) {
  var runtime = new dzn.runtime (function() {console.error ('test: illegal'); throw new Error ('test: oops: illegal'); });
  var loc = new dzn.locator ().set (runtime);

  log = function (s) {
    if (s.includes('transport')) {} else console.log(s);
  };
  loc.set (log, 'trace');

  window.addEventListener("keypress", function(e) { if (e.key == 'h')  showHelp(); }, false);

  var view = new dzn.view.View(loc, {name: 'view'});
  document.title = model;
  view.daemon.daemon_proxy.url = 'ws://127.0.0.1:' + port;
  var stopped = false;

  view.control.out.error = function() {
    console.log('-------------------- VIEW ERROR --------------------');
    stopped = true;
  }

  view.control.in.setup();

  var redraw = function() {
    if (!stopped)
      view.widget.widget.in.redraw();
  };

  if (div == 'all') {
    var eStyle = function(dimension, size, gutterSize) {
      return {'flex-basis': `calc(${size}% - ${gutterSize}px)`};
    };
    var gStyle = function(dimension, gutterSize) {
      return {'flex-basis':  `${gutterSize}px`};
    };

    Split(['#left', '#state'], {
      sizes: [40,60],
      gutterSize: 10,
      direction: 'horizontal',
      elementStyle: eStyle,
      gutterStyle: gStyle,
      onDragEnd: redraw,
    });

    Split(['#system', '#trace'], {
      sizes: [40,59],
      gutterSize: 10,
      direction: 'vertical',
      elementStyle: eStyle,
      gutterStyle: gStyle,
      onDragEnd: redraw,
    });
  }
}

function parse_params() {
  var param_string = window.location.href.replace (/.*\?/, '');
  var params = {};
  param_string.split ('&').forEach (function (p) {var kv = p.split ('=');params[kv[0]]=kv[1];});
  return params;
}

function init (div) {
  var params = parse_params();
  if (params.port) global_view_port = params.port;
  if (params.editor) global_http_port = params.editor;
  init_View (div, params.model || '', global_view_port);
}
