(define-module (command command)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (transport transport_interface)
  #:use-module (transport Serialize)
  #:use-module (transport transport)
  #:use-module (transport Websocket)
  #:use-module (command Daemon_data2event)
  #:duplicates (merge-generics)
  #:export (<command:Icontrol>
    <command:Icontrol.in>
    <command:Icontrol.out>
    .setup
    .set_up
    .command
    .result
    <command:Idaemon>
    <command:Idaemon.in>
    <command:Idaemon.out>
    <command:Idaemon_data2event>
    <command:Idaemon_data2event.in>
    <command:Idaemon_data2event.out>
    .wrap
    .envelope
    <command:Command_controller>
    .control
    .daemon
    <command:Daemon_proxy_controller>
    .transprt
    .busy
    <command:Daemon_proxy>
    .daemon_proxy
    <command:Commander>
    .controller)
  #:re-export (.error
    .disconnect
    .connected
    .data2event
    .state
    <command:Daemon_data2event>))

(define true #t)
(define false #f)

(define (log o string . rest) (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug))) (apply log-debug (cons string rest)))) 




(define command:Icontrol:State:alist
  '((Idle . State_Idle)
    (Setup . State_Setup)
    (Active . State_Active)
    (Busy . State_Busy)
    (Closing . State_Closing)))

(define-class <command:Icontrol.in> (<dzn:port>)
  (setup #:accessor .setup #:init-keyword #:setup)

  (command #:accessor .command #:init-keyword #:command)

)

(define-class <command:Icontrol.out> (<dzn:port>)
  (set_up #:accessor .set_up #:init-keyword #:set_up)

  (result #:accessor .result #:init-keyword #:result)

  (error #:accessor .error #:init-keyword #:error)

  (disconnect #:accessor .disconnect #:init-keyword #:disconnect)

)

(define-class <command:Icontrol> (<dzn:interface>)
)
(define command:Idaemon:State:alist
  '((Idle . State_Idle)
    (Setup . State_Setup)
    (Active . State_Active)
    (Busy . State_Busy)
    (Closing . State_Closing)))

(define-class <command:Idaemon.in> (<dzn:port>)
  (setup #:accessor .setup #:init-keyword #:setup)

  (command #:accessor .command #:init-keyword #:command)

)

(define-class <command:Idaemon.out> (<dzn:port>)
  (connected #:accessor .connected #:init-keyword #:connected)

  (disconnect #:accessor .disconnect #:init-keyword #:disconnect)

  (result #:accessor .result #:init-keyword #:result)

  (error #:accessor .error #:init-keyword #:error)

)

(define-class <command:Idaemon> (<dzn:interface>)
)

(define-class <command:Idaemon_data2event.in> (<dzn:port>)
  (wrap #:accessor .wrap #:init-keyword #:wrap)

  (data2event #:accessor .data2event #:init-keyword #:data2event)

)

(define-class <command:Idaemon_data2event.out> (<dzn:port>)
  (envelope #:accessor .envelope #:init-keyword #:envelope)

  (result #:accessor .result #:init-keyword #:result)

  (error #:accessor .error #:init-keyword #:error)

)

(define-class <command:Idaemon_data2event> (<dzn:interface>)
)
;; (use-modules (transport:Serialize))
;; (use-modules (transport:Websocket))
(define command:Command_controller:State:alist
  '((Idle . State_Idle)
    (Setup . State_Setup)
    (Active . State_Active)
    (Busy . State_Busy)
    (Closing . State_Closing)))


(define-class <command:Command_controller> (<dzn:component>)
  (state #:accessor .state #:init-form (assoc-ref command:Command_controller:State:alist 'Idle))


  (out_control #:accessor .out_control #:init-value #f #:init-keyword #:out_control)


  (control #:accessor .control #:init-form (make <command:Icontrol>) #:init-keyword #:control)

  (daemon #:accessor .daemon #:init-form (make <command:Idaemon>) #:init-keyword #:daemon)

)

(define-method (initialize (o <command:Command_controller>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.control o)
    (make <command:Icontrol>
      #:in (make <command:Icontrol.in>
        #:name "control"
        #:self o
        #:setup (lambda args (call-in o (lambda _ (apply control-setup (cons o args))) `(,(.control o) "setup")))
        #:command (lambda args (call-in o (lambda _ (apply control-command (cons o args))) `(,(.control o) "command")))
      )
      #:out (make <command:Icontrol.out>)))

  (set! (.daemon o)
    (make <command:Idaemon>
      #:in (make <command:Idaemon.in>)
      #:out (make <command:Idaemon.out>
        #:name "daemon"
        #:self o
        #:connected (lambda args (call-out o (lambda _ (apply daemon-connected (cons o args))) `(,(.daemon o) "connected")))
        #:disconnect (lambda args (call-out o (lambda _ (apply daemon-disconnect (cons o args))) `(,(.daemon o) "disconnect")))
        #:result (lambda args (call-out o (lambda _ (apply daemon-result (cons o args))) `(,(.daemon o) "result")))
        #:error (lambda args (call-out o (lambda _ (apply daemon-error (cons o args))) `(,(.daemon o) "error")))
      )))


)


(define-method (control-setup (o <command:Command_controller>) config)

  (cond ((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Idle))

      (let ()
        *unspecified*
        (action o .daemon .in .setup  config)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Setup))
      )
    )((not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (control-command (o <command:Command_controller>) cmd)

  (cond ((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Active))

      (let ()
        *unspecified*
        (action o .daemon .in .command  cmd)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Busy))
      )
    )((not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (daemon-connected (o <command:Command_controller>))

  (cond ((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Setup))

      (let ()
        *unspecified*
        (action o .control .out .set_up  #t)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Active))
      )
    )((not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Setup)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (daemon-disconnect (o <command:Command_controller>) data)

  (cond ((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Active))

      (let ()
        *unspecified*
        (action o .control .out .disconnect  data)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Idle))
      )
    )((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Busy))

      (let ()
        *unspecified*
        (action o .control .out .disconnect  data)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Idle))
      )
    )((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Closing))

      (let ()
        *unspecified*
        (action o .control .out .disconnect  data)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Idle))
      )
    )((and (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Closing))) (and (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Busy))) (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Active)))))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (daemon-result (o <command:Command_controller>) data)

  (cond ((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Busy))

      (let ()
        *unspecified*
        (action o .control .out .result  data)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Active))
      )
    )((not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Busy)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (daemon-error (o <command:Command_controller>) e)

  (cond ((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Idle))
      (action o .control .out .error  e)

    )((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Setup))

      (let ()
        *unspecified*
        (action o .control .out .error  e)

        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Idle))
      )
    )((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Active))

      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Closing))
        (action o .control .out .error  e)

      )
    )((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Busy))
      (set! (.state o) (assoc-ref command:Command_controller:State:alist 'Closing))
    )((eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Closing))
      *unspecified*
    )((and (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Closing))) (and (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Busy))) (and (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Active))) (and (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Setup))) (not (eq? (.state o) (assoc-ref command:Command_controller:State:alist 'Idle)))))))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)

(define command:Daemon_proxy_controller:State:alist
  '((Idle . State_Idle)
    (Setup . State_Setup)
    (Active . State_Active)
    (Closing . State_Closing)
    (Error . State_Error)))


(define-class <command:Daemon_proxy_controller> (<dzn:component>)
  (state #:accessor .state #:init-form (assoc-ref command:Daemon_proxy_controller:State:alist 'Idle))
  (busy #:accessor .busy #:init-form false)


  (out_daemon #:accessor .out_daemon #:init-value #f #:init-keyword #:out_daemon)


  (daemon #:accessor .daemon #:init-form (make <command:Idaemon>) #:init-keyword #:daemon)

  (transprt #:accessor .transprt #:init-form (make <transport:Iwebsocket>) #:init-keyword #:transprt)
  (data2event #:accessor .data2event #:init-form (make <command:Idaemon_data2event>) #:init-keyword #:data2event)

)

(define-method (initialize (o <command:Daemon_proxy_controller>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.daemon o)
    (make <command:Idaemon>
      #:in (make <command:Idaemon.in>
        #:name "daemon"
        #:self o
        #:setup (lambda args (call-in o (lambda _ (apply daemon-setup (cons o args))) `(,(.daemon o) "setup")))
        #:command (lambda args (call-in o (lambda _ (apply daemon-command (cons o args))) `(,(.daemon o) "command")))
      )
      #:out (make <command:Idaemon.out>)))

  (set! (.transprt o)
    (make <transport:Iwebsocket>
      #:in (make <transport:Iwebsocket.in>)
      #:out (make <transport:Iwebsocket.out>
        #:name "transprt"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply transprt-listening (cons o args))) `(,(.transprt o) "listening")))
        #:connected (lambda args (call-out o (lambda _ (apply transprt-connected (cons o args))) `(,(.transprt o) "connected")))
        #:error (lambda args (call-out o (lambda _ (apply transprt-error (cons o args))) `(,(.transprt o) "error")))
        #:message (lambda args (call-out o (lambda _ (apply transprt-message (cons o args))) `(,(.transprt o) "message")))
        #:disconnect (lambda args (call-out o (lambda _ (apply transprt-disconnect (cons o args))) `(,(.transprt o) "disconnect")))
      )))
  (set! (.data2event o)
    (make <command:Idaemon_data2event>
      #:in (make <command:Idaemon_data2event.in>)
      #:out (make <command:Idaemon_data2event.out>
        #:name "data2event"
        #:self o
        #:envelope (lambda args (call-out o (lambda _ (apply data2event-envelope (cons o args))) `(,(.data2event o) "envelope")))
        #:result (lambda args (call-out o (lambda _ (apply data2event-result (cons o args))) `(,(.data2event o) "result")))
        #:error (lambda args (call-out o (lambda _ (apply data2event-error (cons o args))) `(,(.data2event o) "error")))
      )))


)


(define-method (daemon-setup (o <command:Daemon_proxy_controller>) config)

  (cond ((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Idle))

      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Setup))
        (action o .transprt .in .open  config)

      )
    )((not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (daemon-command (o <command:Daemon_proxy_controller>) cmd)

  (cond ((and (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)) (not (.busy o)))

      (let ()
        *unspecified*
        (set! (.busy o) true)
        (action o .data2event .in .wrap  "command" cmd)

      )
    )((not (and (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)) (not (.busy o))))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (transprt-listening (o <command:Daemon_proxy_controller>))

  (cond (true
      (((compose .illegal .runtime) o))))
  *unspecified*
)
(define-method (transprt-connected (o <command:Daemon_proxy_controller>) ws)

  (cond ((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Setup))

      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))
        (action o .daemon .out .connected )

      )
    )((not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Setup)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (transprt-error (o <command:Daemon_proxy_controller>) ws e)

  (cond ((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Setup))

      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Idle))
        (action o .daemon .out .error  e)

      )
    )((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))

      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Closing))
        (action o .daemon .out .error  e)

      )
    )((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Closing))
      *unspecified*
    )((and (not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Closing))) (and (not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))) (not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Setup)))))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (transprt-message (o <command:Daemon_proxy_controller>) ws msg)

  (cond ((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))
      (action o .data2event .in .data2event  msg)

    )((not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (transprt-disconnect (o <command:Daemon_proxy_controller>) ws msg)

  (cond ((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))

      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Idle))
        (set! (.busy o) false)
        (action o .daemon .out .disconnect  msg)

      )
    )((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Closing))

      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Idle))
        (set! (.busy o) false)
        (action o .daemon .out .disconnect  msg)

      )
    )((and (not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Closing))) (not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (data2event-envelope (o <command:Daemon_proxy_controller>) data)

  (cond ((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))
      (action o .transprt .in .send  data)

    )((not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (data2event-result (o <command:Daemon_proxy_controller>) data)

  (cond ((and (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)) (not (.busy o)))
      *unspecified*
    )((and (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)) (.busy o))

      (let ()
        *unspecified*
        (action o .daemon .out .result  data)

        (set! (.busy o) false)
      )
    )((and (not (and (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)) (.busy o))) (not (and (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)) (not (.busy o)))))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)
(define-method (data2event-error (o <command:Daemon_proxy_controller>) e)

  (cond ((eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active))
      *unspecified*
    )((not (eq? (.state o) (assoc-ref command:Daemon_proxy_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))(else ((compose .illegal .runtime) o))
  )
  *unspecified*
)

;; (use-modules (command:Daemon_data2event))
(define-class <command:Daemon_proxy> (<dzn:system>)

  (daemon_proxy #:accessor .daemon_proxy)
  (transprt #:accessor .transprt)
  (data2event #:accessor .data2event)

  (daemon #:accessor .daemon #:init-keyword #:daemon)

)

(define-method (initialize (o <command:Daemon_proxy>) args)
  (next-method)



  (set! (.daemon_proxy o) (make <command:Daemon_proxy_controller> #:locator (.locator o) #:parent o #:name "daemon_proxy"))(set! (.transprt o) (make <transport:Transport_system> #:locator (.locator o) #:parent o #:name "transprt"))(set! (.data2event o) (make <command:Daemon_data2event> #:locator (.locator o) #:parent o #:name "data2event"))
  (set! (.daemon o) (.daemon (.daemon_proxy o)))

  (set! (.out (.daemon o)) (make <command:Idaemon.out>))


  (dzn:connect (.data2event (.data2event o)) (.data2event (.daemon_proxy o)))
  (dzn:connect (.websocket_transport (.transprt o)) (.transprt (.daemon_proxy o)))

  (dzn:rank (.daemon o) 0))
(define-class <command:Commander> (<dzn:system>)

  (controller #:accessor .controller)
  (daemon #:accessor .daemon)

  (control #:accessor .control #:init-keyword #:control)

)

(define-method (initialize (o <command:Commander>) args)
  (next-method)



  (set! (.controller o) (make <command:Command_controller> #:locator (.locator o) #:parent o #:name "controller"))(set! (.daemon o) (make <command:Daemon_proxy> #:locator (.locator o) #:parent o #:name "daemon"))
  (set! (.control o) (.control (.controller o)))

  (set! (.out (.control o)) (make <command:Icontrol.out>))


  (dzn:connect (.daemon (.daemon o)) (.daemon (.controller o)))

  (dzn:rank (.control o) 0))

;; code generator version: 2.11.0.rc9
