(define-module (daemon Verify2event)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (daemon daemon_interface)
  #:duplicates (merge-generics)
  #:export (<daemon:Verify2event>
            .verify))

(define (json-get json key)
  (stderr "json-get: json=~s, key=~s\n" json key)
  (assoc-ref json key))

(define-class <daemon:Verify2event> (<dzn:component>)
  (verify #:accessor .verify #:init-form (make <daemon:Iverify2event>) #:init-keyword #:verify))

(define-method (initialize (o <daemon:Verify2event>) args)
  (next-method)
  (set! (.verify o)
    (make <daemon:Iverify2event>
      #:in (make <daemon:Iverify2event.in>
        #:name "verify"
        #:self o
        #:has_trace (lambda args (call-in o (lambda _ (apply verify-has_trace (cons o args))) `(,(.verify o) has_trace))))
      #:out (make <daemon:Iverify2event.out>))))


(define-method (verify-has_trace (o <daemon:Verify2event>) data)
  (let (;(verify (libenvelope:data data))
        (verify (json-get data "verify")))
    (assoc-ref verify "trace")))
