(define-module (transport Serialize)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (transport transport_interface)
  #:use-module (transport libenvelope)
  #:use-module (transport libtransport)
  #:duplicates (merge-generics)
  #:export (<transport:Serialize>
            .serialize))

(define-class <transport:Serialize> (<dzn:component>)
  (serialize #:accessor .serialize #:init-keyword #:serialize))

(define-method (initialize (o <transport:Serialize>) args)
  (next-method)
  (set! (.serialize o)
        (make <transport:Iserialize>
          #:in (make <transport:Iserialize.in>
                 #:name "serialize"
                 #:self o
                 #:pack (lambda args (call-in o (lambda _ (apply serialize-pack (cons o args))) `(,(.serialize o) pack)))
                 #:unpack (lambda args (call-in o (lambda _ (apply serialize-unpack (cons o args))) `(,(.serialize o) unpack)))
                 #:ping (lambda args (call-in o (lambda _ (apply serialize-ping (cons o args))) `(,(.serialize o) ping))))
          #:out (make <transport:Iserialize.out>))))

(define-method (serialize-pack (o <transport:Serialize>) data)
  (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug)))
    (log-debug "serialize-pack data=~s\n" data))
  (action o .serialize .out .message (if (string? data) data
                                         (libtransport:serialize data))))

(define-method (serialize-unpack (o <transport:Serialize>) msg)
  (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug)))
    (log-debug "serialize-unpack data=~s\n" msg))
  (action o .serialize .out .data (libtransport:unserialize msg)))

(define-method (serialize-ping (o <transport:Serialize>) msg)
  (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug)))
    (log-debug "serialize-ping data=~s\n" msg))
  (action o .serialize .out .pong))
