// Dezyne-IDE --- An IDE for Dezyne
//
// Copyright © 2019 Johri van Eerd <johri.van.eerd@verum.com>
//
// This file is part of Dezyne-IDE.
//
// Dezyne-IDE is property of Verum Software Tools BV <support@verum.com>.
// All rights reserved.


var neutral1 = 'grey';
var accent1  = '#168AB5';
var color_scheme1 = {
  component: {
    component: '#AEE8A0',
    system:    '#C9FFC9',
    foreign:   '#E5FFE5',
    injection: '#CCCCEE',

    port:      '#FFFCB0',
    external:  '#f0f000',

    selected:  '#56734F',
  },
  stroke_low: neutral1,
  stroke_high: accent1,
  state_fill: {
    low:    {'instance+state': '#FFFDE1', 'event': '#FAFAFA', 'start': '#140000'},
    medium: {'instance+state': '#FFF5B4', 'event': '#E3F0F5', 'start': '#2B0000'},
    high:   {'instance+state': '#FFE55A', 'event': '#C8F0FF', 'start': '#5A0000'},
  },
  state_stroke: {
    low:    {'instance+state': neutral1, 'event': neutral1, 'start': neutral1},
    medium: {'instance+state': neutral1, 'event': neutral1, 'start': neutral1},
    high:   {'instance+state': accent1,  'event': accent1,  'start': accent1},
  },
  trace_block: '#E6FFFD',
  stop_border: '#CC0C25',
  stop_width: 4,
};

var neutral2 = 'grey';
var accent2  = '#B30000';
var color_scheme2 = {
  component: {
    component: '#BEE6BE',
    system:    '#CCFFCC',
    foreign:   '#E5FFE5',
    injection: '#CCCCEE',

    port:      '#99F6E6',
    external:  '#f0f000',

    selected:  '#5F735F',
  },
  stroke_low: neutral2,
  stroke_high: accent2,
  state_fill: {
    low:    {'instance+state': '#B9E5F7', 'event': '#FFF4EB', 'start': '#140000'},
    medium: {'instance+state': '#99D8F3', 'event': '#F6DFCF', 'start': '#2B0000'},
    high:   {'instance+state': '#5BC0EB', 'event': '#E5B699', 'start': '#5A0000'},

  },
  state_stroke: {
    low:    {'instance+state': neutral2, 'event': neutral2, 'start': neutral2},
    medium: {'instance+state': neutral2, 'event': neutral2, 'start': neutral2},
    high:   {'instance+state': accent2,  'event': accent2,  'start': accent2},
  },
  trace_block: '#FFF4EB',
  stop_border: '#CC0C25',
  stop_width: 4,
};

var neutral3 = 'grey';
var accent3  = '#B30000';
var color_scheme3 = {
  component: {
    component: '#97CAF6',
    system:    '#D1E4F6',
    foreign:   '#C3CDD6',
    injection: '#CCCCEE',

    port:      '#99F6E6',
    external:  '#f0f000',

    selected:  '#4B657A',
},
  stroke_low: neutral3,
  stroke_high: accent3,
  state_fill: {
    low:    {'instance+state': '#D9F6C8', 'event': '#FEFAF4', 'start': '#140000'},
    medium: {'instance+state': '#BCE7AF', 'event': '#FEEDDE', 'start': '#2B0000'},
    high:   {'instance+state': '#84C97F', 'event': '#FFD5B3', 'start': '#5A0000'},

  },
  state_stroke: {
    low:    {'instance+state': neutral3, 'event': neutral3, 'start': neutral3},
    medium: {'instance+state': neutral3, 'event': neutral3, 'start': neutral3},
    high:   {'instance+state': accent3,  'event': accent3,  'start': accent3},
  },
  trace_block: '#FEFAF4',
  stop_border: '#CC0C25',
  stop_width: 4,
};

var color_scheme = color_scheme1;
