// Dezyne-IDE --- An IDE for Dezyne
//
// Copyright © 2019 Rob Wieringa <Rob.Wieringa@verum.com>
//
// This file is part of Dezyne-IDE.
//
// Dezyne-IDE is property of Verum Software Tools BV <support@verum.com>.
// All rights reserved.

function firstLane(data) {
  for (var i = 0; i < data.length; i++) {
    var msg = data[i];
    switch (msg.type) {
    case "init":
        if (msg.nodes.length > 0) {
          var node = msg.nodes[i];
          if (("key" in node)) {
            return node.key;
          }
          else {
            return node.text;
          }
        }
        break;
    case "transition":
    case "update":
        break;
    }
  }
  return "";
}

function merge1traces(data1) {
  var merged = Array();
  var init = Object();
  init.type = "init";
  init.nodes = Array();
  merged.push(init);
  
  for (var i = 0; i < data1.length; i++) {
    var msg = data1[i];
    
    switch (msg.type) {
    case "init":
        for (var n = 0; n < msg.nodes.length; n++) {
            var node = msg.nodes[n];
            node.trace = "1";
            merged[0].nodes.push(node);
        }
        break;
    case "transition":
    case "update":
    case "error":
        var msg3 = msg;
        msg3.trace = "1";
        merged.push(msg3);
        break;
    }
  }
  return merged;
}

function mergeUntilTransition(merged, data, index, tr) {
  for (var i = index; i < data.length; i++) {
    var msg = data[i];
    switch (msg.type) {
    case "init":
        for (var n = 0; n < msg.nodes.length; n++) {
            var node = msg.nodes[n];
            node.trace = tr;
            merged[0].nodes.push(node);
        }
        break;
    case "transition":
        return i;
        break;
    case "update":
    case "error":
        var msgt = msg;
        msgt.trace = tr;
        merged.push(msgt);
        break;
    }
  }
  return data.length;
}

function merge2traces(data1, data2) {
    var merged = Array();
    var init = Object();
    init.type = "init";
    init.nodes = Array();
    merged.push(init);
    // synchronisation of two traces
    var lane1 = firstLane(data1);
    var lane2 = firstLane(data2);
    
    var i1 = mergeUntilTransition(merged, data1, 0, "1");
    var i2 = mergeUntilTransition(merged, data2, 0, "2");
    
    while (i1 < data1.length && i2 < data2.length) {
      var from1 = data1[i1].from;
      var to1 = data1[i1].to;
      var event1 = data1[i1].event;
      var from2 = data2[i2].from;
      var to2 = data2[i2].to;
      var event2 = data2[i2].event;
      
      if ((from1 == lane1 && from2 == lane2 && event1 == event2) ||
          (to1 == lane1 && to2 == lane2 && event1 == event2)) {
        // matching events: draw both
        var msg1 = data1[i1];
        msg1.trace = "1";
        merged.push(msg1);
        i1 = mergeUntilTransition(merged, data1, i1+1, "1");

        var msg2 = data2[i2];
        msg2.trace = "2";
        merged.push(msg2);
        i2 = mergeUntilTransition(merged, data2, i2+1, "2");
      }
      else if (from1 == lane1 || to1 == lane1) {
        // non-matching events, one primary, one secondary: draw the secondary
        var msg1 = Object();
        msg1.type = "skip";
        msg1.trace = "1";
        merged.push(msg1);

        var msg2 = data2[i2];
        msg2.trace = "2";
        merged.push(msg2);
        i2 = mergeUntilTransition(merged, data2, i2+1, "2");
      }
      else if (from2 == lane2 || to2 == lane2) {
        // non-matching events, one primary, one secondary: draw the secondary
        var msg1 = data1[i1];
        msg1.trace = "1";
        merged.push(msg1);
        i1 = mergeUntilTransition(merged, data1, i1+1, "1");
        
        var msg2 = Object();
        msg2.type = "skip";
        msg2.trace = "2";
        merged.push(msg2);
      }
      else {
        // two non-matching events: process then both at the same line
        var msg1 = data1[i1];
        msg1.trace = "1";
        merged.push(msg1);
        i1 = mergeUntilTransition(merged, data1, i1+1, "1");

        var msg2 = data2[i2];
        msg2.trace = "2";
        merged.push(msg2);
        i2 = mergeUntilTransition(merged, data2, i2+1, "2");
      }
    }
    // process the left-overs:
    while (i1 < data1.length) {
      var msg1 = data1[i1];
      msg1.trace = "1";
      merged.push(msg1);
      i1 = mergeUntilTransition(merged, data1, i1+1, "1");
    }
    while (i2 < data2.length) {
      var msg2 = data2[i2];
      msg2.trace = "2";
      merged.push(msg2);
      i2 = mergeUntilTransition(merged, data2, i2+1, "2");
    }
    return merged;
}
