// Dezyne-IDE --- An IDE for Dezyne
//
// Copyright © 2020 Rob Wieringa <Rob.Wieringa@verum.com>
// Copyright © 2020,2021 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
//
// This file is part of Dezyne-IDE.
//
// Dezyne-IDE is property of Verum Software Tools BV <support@verum.com>.
// All rights reserved.

dzn = dzn || {}
dzn.view = dzn.view || {}

dzn.view.System_widget = function (locator, meta) {
  dzn.runtime.init (this, locator, meta);
  this._dzn.meta.ports = ['widget'];
  this.origin = 'system';

  this.widget = new dzn.view.Iwidget({provides: {name: 'widget', component: this}, requires: {}});

  this.DIV = document.getElementById (this.origin);

  this.sut = {};
  this.data = {root:{elements:[]}};
  this.go_data = {};

  this.blackboxes = function(header) {
    var nodes = this.go_data.nodeDataArray;
    var keys = Object.keys(header);
    return keys
      .filter(function(key) { return header[key].blackboxed; })
      .map(function(key) {
        var node = nodes.find(function(n) {
          // key starts with 'sut', n.key with 'Camera', so:
          return n.key.split('.').slice(1).join('.') == key.split('.').slice(1).join('.');
        });
        return node;
      });
  }

  this.show_trace = function (events, blackboxes) {
    console.log('show trace; events: %j', events);

    var instance = this.sut;
    var nodes = this.go_data.nodeDataArray;
    var links = this.go_data.linkDataArray;

    var trace_nodes = [];
    var trace_links = [];
    var sut_name = this.sut.name;
    var instance_port_list = events
        .filter(function(event) {
          var from_list = event.from.split('.');
          return from_list[from_list.length-1] != '<q>';
        })
        .map(function(event) {
          var from_list = event.from.split('.');
          var port = from_list[from_list.length-1];
          var instance_path = from_list.slice(0,-1);
          if (instance_path[0] == '<external>')
            instance_path = instance_path.slice(1);
          if (instance_path.length == 0 || instance_path[0] == 'sut') instance_path[0] = sut_name;
          return {instance: instance_path.join('.'), port: port};
        });

    var node;
    var previous;
    if (instance_port_list.length) {
      var instance_name = instance_port_list[0].instance;
      node = nodes.find (function (n) {return n.key == instance_name;});
      if (!node) {
        console.log('---------- NOT FOUND: %s IN NODES: %j', instance_name, nodes);
        return;
      }
    }
    instance_port_list.forEach (function (ip) {
      var dir;
      var link;
      var to_node;
      var port_name = ip.port;
      do {
        var from_port = node.portArray.find (function (p) {return p.portId == port_name;});
        if (!from_port) {
          // FIXME: stopcriterium
          console.log ('BREAK');
          break;
        }
        if (node.type != 'system')
          trace_nodes.push(node);
        var from_link = links.find (function (l) {return l.from == node.key && l.fromPort == port_name;});
        var to_link = links.find (function (l) {return l.to == node.key && l.toPort == port_name;});
        if (from_link && to_link) {
          var from_next = from_link.from == node.key ? from_link.to : from_link.from;
          var to_next = to_link.from == node.key ? to_link.to : to_link.from;
          link = (previous && from_next == previous.key) ? to_link : from_link;
        }
        else
          link = from_link || to_link;
        dir = link === from_link ? 'from' : 'to';
        if (link) {
          trace_links.push(link);
          to_node = dir == 'from'
            ? nodes.find (function (n) {return n.key == link.to;})
            : nodes.find (function (n) {return n.key == link.from;});
          previous = node;
          node = to_node;
          if (node.type != 'system')
            trace_nodes.push(node);
          var port = dir == 'from' ? link.toPort : link.fromPort;
          port_name = port.split('.').slice(-1)[0];

        }
      } while (link && node.type == 'system')
    });
    system_go.in.show_trace(blackboxes, trace_nodes, trace_links);
  }.bind (this);

  system_go.out.click = function(location) {
    location['working-directory'] = this.working_directory;
    this.widget.out.selected({selection:[location]});
  }.bind (this);

  system_go.out.selected = function(selection) {
    // TODO: remove this code for [] -> {} when draw receives sexps
    var sel = {system: {}, events: selection.events};
    Object.keys(selection.system).forEach(function (instance) {
      sel.system[instance] = Array.isArray(selection.system[instance]) ? {} : selection.system[instance];
    });
    trace_go.in.set_cursor('wait');
    this.widget.out.selected(sel);
  }.bind(this);

  system_go.out.blackbox = function(instance) {
    system_go.in.set_cursor('wait');
    this.widget.out.blackbox(instance);
  }.bind(this);

  this.widget.in.init = function() {
    if (!this.DIV) return;
    //system_go.in.init();
    system_go.in.set_cursor('');
  };

  this.widget.in.notify = function(notification) {
    if (!this.DIV) return;
      //if (notification.label == 'system') {
      //trace_go.in.set_cursor('wait');
      this.widget.out.request({label:'system',origin:'system'});
  };

  this.widget.in.draw = function(data) {
    if (!this.DIV) return;
    if (!data.system) return;

    data = data.system;
    data = JSON.parse(data);

    console.log ('System_widget data=%j', data);
    if (ast.is_a(data,'root') && data.elements) {
      data.elements.filter (function (o) {return ast.is_p ('component') (o) || ast.is_p ('system') (o);})
        .forEach (function (c) {c.size = ast2go.calcSize (data, c);});

      data.elements.filter (function (o) {return ast.is_p ('namespace') (o);})
        .forEach (function (namespace) {
          function helper (namespace) {
            namespace.elements.filter (function (o) {return ast.is_p ('component') (o) || ast.is_p ('system') (o);})
              .forEach (function (c) {c.size = ast2go.calcSize (data, c);});
            namespace.elements.filter (function (o) {return ast.is_p ('namespace') (o);})
              .forEach (helper);
          }
          helper (namespace);
        });

      var size = -1;
      var sut = {};
      data.elements.filter (function (o) {return ast.is_p ('component') (o) || ast.is_p ('system') (o);})
        .forEach (function (c) {
          if (c.size > size) {size = c.size; sut = c;}});

      data.elements.filter (function (o) {return ast.is_p ('namespace') (o);})
        .forEach (function (namespace) {
          function helper (namespace, ids) {
            namespace.elements.filter (function (o) {return ast.is_p ('component') (o) || ast.is_p ('system') (o);})
              .forEach (function (c) {
                c.name.ids = ids.concat (c.name.ids);
                if (c.size > size) {size = c.size; sut = c;}});
            namespace.elements.filter (function (o) {return ast.is_p ('namespace') (o);})
              .forEach (function (namespace) {
                helper (namespace, ids.concat (namespace.name.ids));
              });
          }
          helper (namespace, namespace.name.ids);
        });

      this.data = data;
      this.working_directory = data["working-directory"]||"";
      this.sut = sut;
      this.go_data = ast2go.ast2go (data, ast2go.toString (sut.name));
      system_go.in.draw (this.go_data);
      document.title = ast2go.toString(sut.name);
    } else if (system_go.diagram && data.trace) {
      return; //FIXME
//      var trace = trail2go.trail2go (data.trace);
//      if (trace.blocks.length <= 1) {
//        this.show_trace ([], []);
//      }
//      else if (trace.blocks.length > 1) {
//        var events = trail2go.internal_events(trace, trace.blocks[trace.blocks.length - 2]);
//        this.show_trace (events, []);
//      }
    }
    system_go.in.set_cursor('');
  };

  this.widget.in.redraw = function() {
    if (!this.DIV) return;
    system_go.in.redraw();
    system_go.in.set_cursor('');
  };

  this.widget.in.go_to = function(selection) {
    return;
    if (!this.DIV) return;
    console.log ('System_widget.go_to: selection=%j', selection);
    if (!system_go.diagram) return;
    var blackboxes = this.blackboxes(selection.selection[0]['instance+state']);
    this.show_trace(selection.selection[0].event, blackboxes);
    system_go.in.set_cursor('');
  }

  this.widget.in.go_to_instance = function(selection) {
    if (!this.DIV) return;
    console.log ('System_widget.go_to_instance: selection=%j', selection);
    //system_go.in.go_to(selection);
    system_go.in.set_cursor('');
  };

  this.widget.in.clear = function() {
    if (!this.DIV) return;
    console.log('hello ViewWidget clear');
    system_go.in.set_cursor('');
  };

  this.widget.in.select = function(pointer) {
    if (!this.DIV) return;
    console.log('System_widget.select');
    system_go.in.set_cursor('');
  };

  this.widget.in.stop = function() {
    if (!this.DIV) return;
    console.log('System_widget stop');
    system_go.in.stop();
    system_go.in.set_cursor('');
  };

  this.widget.in.origin = function() {
    this.widget.out.origin_label({label:this.origin,origin:this.origin});
  }

    this.widget.in.go_to_index = function() {};

  if (!this.DIV) return;
  system_go.in.init();
  this._dzn.rt.bind (this);
};

if (node_p ()) {
  // nodejs
  module.exports = dzn;
}
