;;; Dezyne-IDE --- An IDE for Dezyne
;;;
;;; Copyright © 2020 Rob Wieringa <Rob.Wieringa@verum.com>
;;; Copyright © 2020,2021 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2020 Rutger van Beusekom <rutger.van.beusekom@verum.com>
;;;
;;; This file is part of Dezyne-IDE.
;;;
;;; Dezyne-IDE is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (daemon Command_data2event)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (daemon daemon_interface)
  #:use-module (transport libenvelope)
  #:use-module (ice-9 match)
  #:use-module (ide util)
  #:duplicates (merge-generics)
  #:export (<daemon:Command_data2event>
            .command_data2event))

(define-class <daemon:Command_data2event> (<dzn:component>)
  (command_data2event #:accessor .command_data2event #:init-form (make <daemon:Icommand_data2event>) #:init-keyword #:command_data2event)
)

(define-method (initialize (o <daemon:Command_data2event>) args)
  (next-method)
  (set! (.command_data2event o)
    (make <daemon:Icommand_data2event>
      #:in (make <daemon:Icommand_data2event.in>
        #:name "command_data2event"
        #:self o
        #:wrap (lambda args (call-in o (lambda _ (apply command_data2event-wrap (cons o args))) `(,(.command_data2event o) wrap)))
        #:unwrap (lambda args (call-in o (lambda _ (apply command_data2event-unwrap (cons o args))) `(,(.command_data2event o) unwrap))))
      #:out (make <daemon:Icommand_data2event.out>)))
)

(define-method (command_data2event-wrap (o <daemon:Command_data2event>) label data)
  ;; XXX TODO: Truncating the parse data speeds-up ide parse
  ;; time ./pre-inst-env ide parse -I dzn dzn/all.dzn
  ;; LENGTH: 969.444 ~ 1MB
  ;; => real 1m15.491s
  ;;    user 3m24.474s
  ;; truncated:
  ;; => real 0m6.780s
  ;;    user 0m0.815s
  ;; Also, terrible "coding" of messages:
  ;;   * (parse "err" "<the-error-string>") ;status, stderr are missing
  ;;   * (parse "<json-data>")              ;status, stderr are missing
  (let ((truncated-data (match data
                          ((('parse "err" (? string? error)))
                           data)
                          ((('parse . (? string? string)))
                           (log-debug "LENGTH: ~a\n" (string-length string))
                           ;; (with-output-to-file "data.json" (lambda _ (display string)))
                           '((parse . "{\"truncated\":true}")))
                          (_ data))))
    (action o .command_data2event .out .wrapped (libenvelope:wrap label truncated-data))))

(define-method (command_data2event-unwrap (o <daemon:Command_data2event>) data)
  (let ((label (libenvelope:label data))
        (data (libenvelope:data data)))
    (case label
      ((command) (action o .command_data2event .out .command data))
      ((wrapped) (action o .command_data2event .out .wrapped data))
      (else (stderr "Command_data2event: no such label: ~s\n" label)
            (action o .command_data2event .out .error)))))
