;;; Dezyne --- Dezyne command line tools
;;;
;;; Copyright © 2017, 2018, 2019, 2020, 2021 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2018 Rutger van Beusekom <rutger.van.beusekom@verum.com>
;;;
;;; This file is part of Dezyne.
;;;
;;; Dezyne is free software: you can redistribute it and/or modify it
;;; under the terms of the GNU Affero General Public License as
;;; published by the Free Software Foundation, either version 3 of the
;;; License, or (at your option) any later version.
;;;
;;; Dezyne is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; Affero General Public License for more details.
;;;
;;; You should have received a copy of the GNU Affero General Public
;;; License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.
;;;
;;; Commentary:
;;;
;;; Compile-time configuration of dzn.  When adding a substitution
;;; variable here, make sure to have configure substitute it.
;;;
;;; Code:

(define-module (dzn config)
  #:use-module (dzn shell-util)
  #:export (%bindir
            %datadir
            %datarootdir
            %dzn
            %guilemoduledir
            %guileobjectdir
            %default-languages
            %package
            %prefix
            %template-dir
            %test-dir
            %version
            %version-major
            %version-minor
            %version-patch))

(define %package
  (or (and (getenv "DZN_UNINSTALLED") "dezyne")
      "dezyne"))

(define %prefix
  (or (and (getenv "DZN_UNINSTALLED") (getenv "DZN_PREFIX"))
      "/gnu/store/jy1q66v3y04npzv83mqni45ki6g1vsnm-dezyne-mingw-2.13.1"))

(define %datadir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      "/gnu/store/jy1q66v3y04npzv83mqni45ki6g1vsnm-dezyne-mingw-2.13.1/share"))

(define %datarootdir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      "/gnu/store/jy1q66v3y04npzv83mqni45ki6g1vsnm-dezyne-mingw-2.13.1/share"))

(define %pkgdatadir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      (getenv "DZN_DATADIR")
      (string-append %datadir "/" %package)))

(define %bindir
  (or (and (getenv "DZN_UNINSTALLED") (string-append %prefix "/bin"))
      "/gnu/store/jy1q66v3y04npzv83mqni45ki6g1vsnm-dezyne-mingw-2.13.1/bin"))

(define %template-dir
  (string-append %pkgdatadir "/dzn/templates"))

(define %test-dir
  (string-append %pkgdatadir "/test"))

(define %guilemoduledir
  "/gnu/store/jy1q66v3y04npzv83mqni45ki6g1vsnm-dezyne-mingw-2.13.1/share/guile/site/2.2")

(define %guileobjectdir
  "/gnu/store/jy1q66v3y04npzv83mqni45ki6g1vsnm-dezyne-mingw-2.13.1/lib/guile/2.2/site-ccache")

(define %version
  "2.13.1")

(define %version-major
  2)

(define %version-minor
  13)

(define %version-patch
  1)

(define %dzn
  (if (mingw?) "dzn.cmd"
      (string-append %bindir "/dzn")))

(define %default-languages
  (string-split (string-trim-both "c++") #\space))
