;;; Generated by dzn code from dzn/daemon/daemon.dzn
(define-module (daemon daemon)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (daemon daemon_interface)
  #:use-module (transport transport_interface)
  #:use-module (transport Serialize)
  #:use-module (transport transport)
  #:use-module (transport Websocket)
  #:use-module (daemon Command_data2event)
  #:use-module (daemon View_data2event)
  #:use-module (daemon Editor_data2event)
  #:use-module (daemon Dzn_proxy)
  #:use-module (daemon Data)
  #:use-module (daemon Routing)
  #:duplicates (merge-generics)
  #:export (<daemon:Icommand>
    <daemon:Icommand.in>
    <daemon:Icommand.out>
    .dummy
    <daemon:Istore>
    <daemon:Istore.in>
    <daemon:Istore.out>
    .update
    <daemon:Iconnect>
    <daemon:Iconnect.in>
    <daemon:Iconnect.out>
    <daemon:Iview>
    <daemon:Iview.in>
    <daemon:Iview.out>
    .notify
    .go_to
    .go_to_index
    <daemon:Daemon_controller>
    .start
    .store
    .view
    .vconnect
    .iconnect
    .editor
    .econnect
    .vconnected
    .iconnected
    .econnected
    .iconfig
    .vconfig
    .econfig
    <daemon:Command_proxy>
    .connect
    .controller
    .data2event
    .transprt
    <daemon:Command_proxy_controller>
    .socket
    .config
    .task
    <daemon:View_proxy>
    <daemon:View_proxy_controller>
    <daemon:Editor_proxy>
    <daemon:Editor_proxy_controller>
    <daemon:Store_controller>
    <daemon:Store>
    <daemon:Daemon>
    .command_proxy
    .view_proxy
    .editor_proxy)
  #:re-export (.command
    .result
    .setup
    .request
    .back
    .event
    .get_selection
    .get_location
    .listening
    .error
    .connected
    .disconnect
    .selected
    .index_selected
    .routing
    .state
    .dz
    .data
    <daemon:Command_data2event>
    .command_data2event
    <daemon:View_data2event>
    .view_data2event
    <daemon:Editor_data2event>
    .editor_data2event
    <daemon:Dzn_proxy>
    <daemon:Data>
    <daemon:Routing>))

(define true #t)
(define false #f)

(define (log o string . rest) (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug))) (apply log-debug (cons string rest))))
(define daemon:Icommand:State:alist
  '((Idle . State_Idle)
    (Busy . State_Busy)))
(define-class <daemon:Icommand.in> (<dzn:port>)
  (dummy #:accessor .dummy #:init-keyword #:dummy)
  (result #:accessor .result #:init-keyword #:result))

(define-class <daemon:Icommand.out> (<dzn:port>)
  (command #:accessor .command #:init-keyword #:command))

(define-class <daemon:Icommand> (<dzn:interface>))

(define daemon:Istore:State:alist
  '((Idle . State_Idle)
    (Active . State_Active)
    (Busy . State_Busy)
    (Canceling . State_Canceling)))
(define-class <daemon:Istore.in> (<dzn:port>)
  (setup #:accessor .setup #:init-keyword #:setup)
  (command #:accessor .command #:init-keyword #:command)
  (request #:accessor .request #:init-keyword #:request)
  (back #:accessor .back #:init-keyword #:back)
  (event #:accessor .event #:init-keyword #:event)
  (get_selection #:accessor .get_selection #:init-keyword #:get_selection)
  (get_location #:accessor .get_location #:init-keyword #:get_location))

(define-class <daemon:Istore.out> (<dzn:port>)
  (result #:accessor .result #:init-keyword #:result)
  (update #:accessor .update #:init-keyword #:update))

(define-class <daemon:Istore> (<dzn:interface>))

(define daemon:Iconnect:State:alist
  '((Idle . State_Idle)
    (Disconnected . State_Disconnected)
    (Connected . State_Connected)))
(define-class <daemon:Iconnect.in> (<dzn:port>)
  (setup #:accessor .setup #:init-keyword #:setup))

(define-class <daemon:Iconnect.out> (<dzn:port>)
  (listening #:accessor .listening #:init-keyword #:listening)
  (error #:accessor .error #:init-keyword #:error)
  (connected #:accessor .connected #:init-keyword #:connected)
  (disconnect #:accessor .disconnect #:init-keyword #:disconnect))

(define-class <daemon:Iconnect> (<dzn:interface>))


(define-class <daemon:Iview.in> (<dzn:port>)
  (notify #:accessor .notify #:init-keyword #:notify)
  (update #:accessor .update #:init-keyword #:update)
  (go_to #:accessor .go_to #:init-keyword #:go_to)
  (go_to_index #:accessor .go_to_index #:init-keyword #:go_to_index))

(define-class <daemon:Iview.out> (<dzn:port>)
  (request #:accessor .request #:init-keyword #:request)
  (selected #:accessor .selected #:init-keyword #:selected)
  (index_selected #:accessor .index_selected #:init-keyword #:index_selected)
  (back #:accessor .back #:init-keyword #:back)
  (event #:accessor .event #:init-keyword #:event))

(define-class <daemon:Iview> (<dzn:interface>))

(define daemon:Daemon_controller:State:alist
  '((Initial . State_Initial)
    (Ready . State_Ready)
    (Error . State_Error)
    (CommandBusy . State_CommandBusy)
    (ViewBusy . State_ViewBusy)))

(define-class <daemon:Daemon_controller> (<dzn:component>)
  (state #:accessor .state #:init-form (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
  (vconnected #:accessor .vconnected #:init-form false)
  (iconnected #:accessor .iconnected #:init-form false)
  (econnected #:accessor .econnected #:init-form false)
  (iconfig #:accessor .iconfig #:init-form *unspecified*)
  (vconfig #:accessor .vconfig #:init-form *unspecified*)
  (econfig #:accessor .econfig #:init-form *unspecified*)
  (reply-bool #:accessor .reply-bool #:init-value *unspecified*)
  (out_start #:accessor .out_start #:init-value #f #:init-keyword #:out_start)
  (start #:accessor .start #:init-form (make <daemon:Istart>) #:init-keyword #:start)
  (store #:accessor .store #:init-form (make <daemon:Istore>) #:init-keyword #:store)
  (view #:accessor .view #:init-form (make <daemon:Iview>) #:init-keyword #:view)
  (vconnect #:accessor .vconnect #:init-form (make <daemon:Iconnect>) #:init-keyword #:vconnect)
  (command #:accessor .command #:init-form (make <daemon:Icommand>) #:init-keyword #:command)
  (iconnect #:accessor .iconnect #:init-form (make <daemon:Iconnect>) #:init-keyword #:iconnect)
  (editor #:accessor .editor #:init-form (make <daemon:Ieditor>) #:init-keyword #:editor)
  (econnect #:accessor .econnect #:init-form (make <daemon:Iconnect>) #:init-keyword #:econnect)
  (routing #:accessor .routing #:init-form (make <daemon:Irouting>) #:init-keyword #:routing))

(define-method (initialize (o <daemon:Daemon_controller>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.start o)
    (make <daemon:Istart>
      #:in (make <daemon:Istart.in>
        #:name "start"
        #:self o
        #:setup (lambda args (call-in o (lambda _ (apply start-setup (cons o args))) `(,(.start o) "setup"))))
      #:out (make <daemon:Istart.out>)))
  (set! (.store o)
    (make <daemon:Istore>
      #:in (make <daemon:Istore.in>)
      #:out (make <daemon:Istore.out>
        #:name "store"
        #:self o
        #:result (lambda args (call-out o (lambda _ (apply store-result (cons o args))) `(,(.store o) "result")))
        #:update (lambda args (call-out o (lambda _ (apply store-update (cons o args))) `(,(.store o) "update"))))))
  (set! (.view o)
    (make <daemon:Iview>
      #:in (make <daemon:Iview.in>)
      #:out (make <daemon:Iview.out>
        #:name "view"
        #:self o
        #:request (lambda args (call-out o (lambda _ (apply view-request (cons o args))) `(,(.view o) "request")))
        #:selected (lambda args (call-out o (lambda _ (apply view-selected (cons o args))) `(,(.view o) "selected")))
        #:index_selected (lambda args (call-out o (lambda _ (apply view-index_selected (cons o args))) `(,(.view o) "index_selected")))
        #:back (lambda args (call-out o (lambda _ (apply view-back (cons o args))) `(,(.view o) "back")))
        #:event (lambda args (call-out o (lambda _ (apply view-event (cons o args))) `(,(.view o) "event"))))))
  (set! (.vconnect o)
    (make <daemon:Iconnect>
      #:in (make <daemon:Iconnect.in>)
      #:out (make <daemon:Iconnect.out>
        #:name "vconnect"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply vconnect-listening (cons o args))) `(,(.vconnect o) "listening")))
        #:error (lambda args (call-out o (lambda _ (apply vconnect-error (cons o args))) `(,(.vconnect o) "error")))
        #:connected (lambda args (call-out o (lambda _ (apply vconnect-connected (cons o args))) `(,(.vconnect o) "connected")))
        #:disconnect (lambda args (call-out o (lambda _ (apply vconnect-disconnect (cons o args))) `(,(.vconnect o) "disconnect"))))))
  (set! (.command o)
    (make <daemon:Icommand>
      #:in (make <daemon:Icommand.in>)
      #:out (make <daemon:Icommand.out>
        #:name "command"
        #:self o
        #:command (lambda args (call-out o (lambda _ (apply command-command (cons o args))) `(,(.command o) "command"))))))
  (set! (.iconnect o)
    (make <daemon:Iconnect>
      #:in (make <daemon:Iconnect.in>)
      #:out (make <daemon:Iconnect.out>
        #:name "iconnect"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply iconnect-listening (cons o args))) `(,(.iconnect o) "listening")))
        #:error (lambda args (call-out o (lambda _ (apply iconnect-error (cons o args))) `(,(.iconnect o) "error")))
        #:connected (lambda args (call-out o (lambda _ (apply iconnect-connected (cons o args))) `(,(.iconnect o) "connected")))
        #:disconnect (lambda args (call-out o (lambda _ (apply iconnect-disconnect (cons o args))) `(,(.iconnect o) "disconnect"))))))
  (set! (.editor o)
    (make <daemon:Ieditor>
      #:in (make <daemon:Ieditor.in>)
      #:out (make <daemon:Ieditor.out>
        #:name "editor"
        #:self o)))
  (set! (.econnect o)
    (make <daemon:Iconnect>
      #:in (make <daemon:Iconnect.in>)
      #:out (make <daemon:Iconnect.out>
        #:name "econnect"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply econnect-listening (cons o args))) `(,(.econnect o) "listening")))
        #:error (lambda args (call-out o (lambda _ (apply econnect-error (cons o args))) `(,(.econnect o) "error")))
        #:connected (lambda args (call-out o (lambda _ (apply econnect-connected (cons o args))) `(,(.econnect o) "connected")))
        #:disconnect (lambda args (call-out o (lambda _ (apply econnect-disconnect (cons o args))) `(,(.econnect o) "disconnect"))))))
  (set! (.routing o)
    (make <daemon:Irouting>
      #:in (make <daemon:Irouting.in>)
      #:out (make <daemon:Irouting.out>
        #:name "routing"
        #:self o))))

(define-method (start-setup (o <daemon:Daemon_controller>) iconfigx vconfigx econfigx)
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
      (let ()
        *unspecified*
        (set! (.iconfig o) iconfigx)
        (set! (.vconfig o) vconfigx)
        (set! (.econfig o) econfigx)
        (action o .store .in .setup )
        (action o .iconnect .in .setup  (.iconfig o))))
    ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))
      *unspecified*)
    ((and (not (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))) (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (store-result (o <daemon:Daemon_controller>) data)
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'CommandBusy))
      (let ((label *unspecified*)
          (foo *unspecified*))
        *unspecified*
        (action o .command .in .result  data)
        (set! label (cons 'v  *unspecified*))
        (action o .routing .in .storedata2viewlabel  data label)
        (set! foo (cons 'v  (log o "----- state = ~s, view.request: label=~s\n" (.state o) label)))
        (if (.vconnected o)
          (action o .view .in .notify  (cdr label)))
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))))
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'ViewBusy))
      (let ((label *unspecified*)
          (foo *unspecified*))
        *unspecified*
        (set! label (cons 'v  *unspecified*))
        (action o .routing .in .storedata2viewlabel  data label)
        (set! foo (cons 'v  (log o "----- state = ~s, view.request: label=~s\n" (.state o) label)))
        (if (.vconnected o)
          (action o .view .in .notify  (cdr label)))
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))))
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'ViewBusy))) (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'CommandBusy))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (store-update (o <daemon:Daemon_controller>) data)
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))
      (let ((out_data *unspecified*)
          (foo *unspecified*)
          (selection *unspecified*)
          (valid *unspecified*))
        *unspecified*
        (set! out_data (cons 'v  *unspecified*))
        (action o .routing .in .storedata2viewdata  data out_data)
        (set! foo (cons 'v  (log o "----- store.update: view.update\n")))
        (action o .view .in .update  (cdr out_data))
        (set! selection (cons 'v  *unspecified*))
        (set! valid (cons 'v  (action o .store .in .get_selection  selection)))
        (if (cdr valid)
          (action o .view .in .go_to  (cdr selection)))
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))))
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'CommandBusy))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'ViewBusy))
      *unspecified*)
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'ViewBusy))) (and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'CommandBusy))) (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-request (o <daemon:Daemon_controller>) notification)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))
      (let ((foo *unspecified*))
        *unspecified*
        (set! foo (cons 'v  (log o "----- state = ~s, view.request: notification=~s\n" (.state o) notification)))))
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))
      (let ((foo *unspecified*)
          (notification2 *unspecified*))
        *unspecified*
        (set! foo (cons 'v  (log o "----- state = ~s, view.request: notification=~s\n" (.state o) notification)))
        (set! notification2 (cons 'v  *unspecified*))
        (action o .routing .in .viewlabel2storelabel  notification notification2)
        (action o .store .in .request  (cdr notification2))))
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))) (not (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-selected (o <daemon:Daemon_controller>) selection)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))
      (let ((foo *unspecified*)
          (out_selection *unspecified*))
        *unspecified*
        (set! foo (cons 'v  (log o "----- state = ~s, view.request: selection=~s\n" (.state o) selection)))
        (action o .view .in .go_to  selection)
        (set! out_selection (cons 'v  *unspecified*))
        (action o .store .in .get_location  selection out_selection)
        (action o .editor .in .go_to_location  (cdr out_selection))))
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))) (not (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-index_selected (o <daemon:Daemon_controller>) selection)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))
      (let ((out_selection *unspecified*))
        *unspecified*
        (set! out_selection (cons 'v  *unspecified*))
        (action o .store .in .get_location  selection out_selection)
        (action o .editor .in .go_to_location  (cdr out_selection))
        (action o .view .in .go_to_index  selection)))
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))) (not (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-back (o <daemon:Daemon_controller>))
  (cond ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))
      (let ()
        *unspecified*
        (action o .store .in .back )
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'ViewBusy))))
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))) (not (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-event (o <daemon:Daemon_controller>) event)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))
      (let ((foo *unspecified*))
        *unspecified*
        (set! foo (cons 'v  (log o "----- EVENT")))
        (action o .store .in .event  event)
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'ViewBusy))))
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))) (not (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (vconnect-listening (o <daemon:Daemon_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
      (let ()
        *unspecified*
        (action o .econnect .in .setup  (.econfig o))))
    ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (vconnect-error (o <daemon:Daemon_controller>) e)
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
      (let ()
        *unspecified*
        (action o .start .out .error  e)
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Error))))
    ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (vconnect-connected (o <daemon:Daemon_controller>))
  (cond ((not (.vconnected o))
      (set! (.vconnected o) true))
    ((not (not (.vconnected o)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (vconnect-disconnect (o <daemon:Daemon_controller>) msg)
  (cond (true
      (set! (.vconnected o) false))
    (false
      (((compose .illegal .runtime) o))))
  *unspecified*)

(define-method (command-command (o <daemon:Daemon_controller>) cmd)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))
      (let ()
        *unspecified*
        (action o .store .in .command  cmd)
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'CommandBusy))))
    ((and (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))) (not (not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (iconnect-listening (o <daemon:Daemon_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
      (let ()
        *unspecified*
        (action o .vconnect .in .setup  (.vconfig o))))
    ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (iconnect-error (o <daemon:Daemon_controller>) e)
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
      (let ()
        *unspecified*
        (action o .start .out .error  e)
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Error))))
    ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (iconnect-connected (o <daemon:Daemon_controller>))
  (cond ((not (.iconnected o))
      (set! (.iconnected o) true))
    ((not (not (.iconnected o)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (iconnect-disconnect (o <daemon:Daemon_controller>) msg)
  (cond (true
      (set! (.iconnected o) false))
    (false
      (((compose .illegal .runtime) o))))
  *unspecified*)

(define-method (econnect-listening (o <daemon:Daemon_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
      (let ()
        *unspecified*
        (action o .start .out .set_up )
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Ready))))
    ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (econnect-error (o <daemon:Daemon_controller>) e)
  (cond ((eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial))
      (let ()
        *unspecified*
        (action o .start .out .error  e)
        (set! (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Error))))
    ((not (eq? (.state o) (assoc-ref daemon:Daemon_controller:State:alist 'Initial)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (econnect-connected (o <daemon:Daemon_controller>))
  (cond ((not (.econnected o))
      (set! (.econnected o) true))
    ((not (not (.econnected o)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (econnect-disconnect (o <daemon:Daemon_controller>) msg)
  (cond (true
      (set! (.econnected o) false))
    (false
      (((compose .illegal .runtime) o))))
  *unspecified*)

(define daemon:Command_proxy_controller:State:alist
  '((Idle . State_Idle)
    (Listening . State_Listening)
    (Connected . State_Connected)))
(define daemon:Command_proxy_controller:Task:alist
  '((Idle . Task_Idle)
    (Busy . Task_Busy)))

(define-class <daemon:Command_proxy_controller> (<dzn:component>)
  (config #:accessor .config #:init-form *unspecified*)
  (state #:accessor .state #:init-form (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle))
  (task #:accessor .task #:init-form (assoc-ref daemon:Command_proxy_controller:Task:alist 'Idle))
  (out_command #:accessor .out_command #:init-value #f #:init-keyword #:out_command)
  (out_connect #:accessor .out_connect #:init-value #f #:init-keyword #:out_connect)
  (command #:accessor .command #:init-form (make <daemon:Icommand>) #:init-keyword #:command)
  (connect #:accessor .connect #:init-form (make <daemon:Iconnect>) #:init-keyword #:connect)
  (socket #:accessor .socket #:init-form (make <transport:Iwebsocket>) #:init-keyword #:socket)
  (data2event #:accessor .data2event #:init-form (make <daemon:Icommand_data2event>) #:init-keyword #:data2event))

(define-method (initialize (o <daemon:Command_proxy_controller>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.command o)
    (make <daemon:Icommand>
      #:in (make <daemon:Icommand.in>
        #:name "command"
        #:self o
        #:dummy (lambda args (call-in o (lambda _ (apply command-dummy (cons o args))) `(,(.command o) "dummy")))
        #:result (lambda args (call-in o (lambda _ (apply command-result (cons o args))) `(,(.command o) "result"))))
      #:out (make <daemon:Icommand.out>)))
  (set! (.connect o)
    (make <daemon:Iconnect>
      #:in (make <daemon:Iconnect.in>
        #:name "connect"
        #:self o
        #:setup (lambda args (call-in o (lambda _ (apply connect-setup (cons o args))) `(,(.connect o) "setup"))))
      #:out (make <daemon:Iconnect.out>)))
  (set! (.socket o)
    (make <transport:Iwebsocket>
      #:in (make <transport:Iwebsocket.in>)
      #:out (make <transport:Iwebsocket.out>
        #:name "socket"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply socket-listening (cons o args))) `(,(.socket o) "listening")))
        #:connected (lambda args (call-out o (lambda _ (apply socket-connected (cons o args))) `(,(.socket o) "connected")))
        #:error (lambda args (call-out o (lambda _ (apply socket-error (cons o args))) `(,(.socket o) "error")))
        #:message (lambda args (call-out o (lambda _ (apply socket-message (cons o args))) `(,(.socket o) "message")))
        #:disconnect (lambda args (call-out o (lambda _ (apply socket-disconnect (cons o args))) `(,(.socket o) "disconnect"))))))
  (set! (.data2event o)
    (make <daemon:Icommand_data2event>
      #:in (make <daemon:Icommand_data2event.in>)
      #:out (make <daemon:Icommand_data2event.out>
        #:name "data2event"
        #:self o
        #:wrapped (lambda args (call-out o (lambda _ (apply data2event-wrapped (cons o args))) `(,(.data2event o) "wrapped")))
        #:command (lambda args (call-out o (lambda _ (apply data2event-command (cons o args))) `(,(.data2event o) "command")))))))

(define-method (command-dummy (o <daemon:Command_proxy_controller>))
  (cond (true
      *unspecified*)
    (false
      (((compose .illegal .runtime) o))))
  *unspecified*)

(define-method (command-result (o <daemon:Command_proxy_controller>) data)
  (cond ((and (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy)))
      (let ()
        *unspecified*
        (action o .data2event .in .wrap  "result" data)
        (set! (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Idle))))
    ((and (not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy)))
      (set! (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Idle)))
    ((and (not (and (not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy)))) (not (and (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (connect-setup (o <daemon:Command_proxy_controller>) configx)
  (cond ((eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .socket .in .listen  configx)))
    ((not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-listening (o <daemon:Command_proxy_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .connect .out .listening )
        (set! (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Listening))))
    ((not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-connected (o <daemon:Command_proxy_controller>) ws)
  (cond ((eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Listening))
      (let ()
        *unspecified*
        (action o .connect .out .connected )
        (set! (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))))
    ((not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Listening)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-error (o <daemon:Command_proxy_controller>) ws e)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .connect .out .error  e)))
    ((and (not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle))) (not (not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Idle)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-message (o <daemon:Command_proxy_controller>) ws msg)
  (cond ((eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))
      (action o .data2event .in .unwrap  msg))
    ((not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-disconnect (o <daemon:Command_proxy_controller>) ws msg)
  (cond ((eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))
      (let ((foo *unspecified*))
        *unspecified*
        (set! foo (cons 'v  (log o "Command disconnect=~s\n" msg)))
        (action o .connect .out .disconnect  msg)
        (set! (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Listening))))
    ((not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-wrapped (o <daemon:Command_proxy_controller>) data)
  (cond ((eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))
      (action o .socket .in .send  data))
    ((not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-command (o <daemon:Command_proxy_controller>) cmd)
  (cond ((and (not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy)))
      *unspecified*)
    ((and (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Idle)))
      (let ()
        *unspecified*
        (action o .command .out .command  cmd)
        (set! (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy))))
    ((and (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy)))
      *unspecified*)
    ((and (not (and (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy)))) (and (not (and (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected)) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Idle)))) (not (and (not (eq? (.state o) (assoc-ref daemon:Command_proxy_controller:State:alist 'Connected))) (eq? (.task o) (assoc-ref daemon:Command_proxy_controller:Task:alist 'Busy))))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

;; (use-modules (daemon:Command_data2event))

(define daemon:View_proxy_controller:State:alist
  '((Idle . State_Idle)
    (Listening . State_Listening)
    (Connected . State_Connected)))

(define-class <daemon:View_proxy_controller> (<dzn:component>)
  (config #:accessor .config #:init-form *unspecified*)
  (state #:accessor .state #:init-form (assoc-ref daemon:View_proxy_controller:State:alist 'Idle))
  (out_view #:accessor .out_view #:init-value #f #:init-keyword #:out_view)
  (out_connect #:accessor .out_connect #:init-value #f #:init-keyword #:out_connect)
  (view #:accessor .view #:init-form (make <daemon:Iview>) #:init-keyword #:view)
  (connect #:accessor .connect #:init-form (make <daemon:Iconnect>) #:init-keyword #:connect)
  (socket #:accessor .socket #:init-form (make <transport:Iwebsocket>) #:init-keyword #:socket)
  (data2event #:accessor .data2event #:init-form (make <daemon:Iview_data2event>) #:init-keyword #:data2event))

(define-method (initialize (o <daemon:View_proxy_controller>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.view o)
    (make <daemon:Iview>
      #:in (make <daemon:Iview.in>
        #:name "view"
        #:self o
        #:notify (lambda args (call-in o (lambda _ (apply view-notify (cons o args))) `(,(.view o) "notify")))
        #:update (lambda args (call-in o (lambda _ (apply view-update (cons o args))) `(,(.view o) "update")))
        #:go_to (lambda args (call-in o (lambda _ (apply view-go_to (cons o args))) `(,(.view o) "go_to")))
        #:go_to_index (lambda args (call-in o (lambda _ (apply view-go_to_index (cons o args))) `(,(.view o) "go_to_index"))))
      #:out (make <daemon:Iview.out>)))
  (set! (.connect o)
    (make <daemon:Iconnect>
      #:in (make <daemon:Iconnect.in>
        #:name "connect"
        #:self o
        #:setup (lambda args (call-in o (lambda _ (apply connect-setup (cons o args))) `(,(.connect o) "setup"))))
      #:out (make <daemon:Iconnect.out>)))
  (set! (.socket o)
    (make <transport:Iwebsocket>
      #:in (make <transport:Iwebsocket.in>)
      #:out (make <transport:Iwebsocket.out>
        #:name "socket"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply socket-listening (cons o args))) `(,(.socket o) "listening")))
        #:connected (lambda args (call-out o (lambda _ (apply socket-connected (cons o args))) `(,(.socket o) "connected")))
        #:error (lambda args (call-out o (lambda _ (apply socket-error (cons o args))) `(,(.socket o) "error")))
        #:message (lambda args (call-out o (lambda _ (apply socket-message (cons o args))) `(,(.socket o) "message")))
        #:disconnect (lambda args (call-out o (lambda _ (apply socket-disconnect (cons o args))) `(,(.socket o) "disconnect"))))))
  (set! (.data2event o)
    (make <daemon:Iview_data2event>
      #:in (make <daemon:Iview_data2event.in>)
      #:out (make <daemon:Iview_data2event.out>
        #:name "data2event"
        #:self o
        #:wrapped (lambda args (call-out o (lambda _ (apply data2event-wrapped (cons o args))) `(,(.data2event o) "wrapped")))
        #:request (lambda args (call-out o (lambda _ (apply data2event-request (cons o args))) `(,(.data2event o) "request")))
        #:selected (lambda args (call-out o (lambda _ (apply data2event-selected (cons o args))) `(,(.data2event o) "selected")))
        #:index_selected (lambda args (call-out o (lambda _ (apply data2event-index_selected (cons o args))) `(,(.data2event o) "index_selected")))
        #:back (lambda args (call-out o (lambda _ (apply data2event-back (cons o args))) `(,(.data2event o) "back")))
        #:event (lambda args (call-out o (lambda _ (apply data2event-event (cons o args))) `(,(.data2event o) "event")))))))

(define-method (view-notify (o <daemon:View_proxy_controller>) notification)
  (cond ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (let ()
        *unspecified*
        (action o .data2event .in .wrap  "notify" notification)))
    ((and (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))) (not (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-update (o <daemon:View_proxy_controller>) data)
  (cond ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .data2event .in .wrap  "data" data))
    ((and (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))) (not (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-go_to (o <daemon:View_proxy_controller>) selection)
  (cond ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .data2event .in .wrap  "go_to" selection))
    ((and (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))) (not (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (view-go_to_index (o <daemon:View_proxy_controller>) selection)
  (cond ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .data2event .in .wrap  "go_to_index" selection))
    ((and (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))) (not (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (connect-setup (o <daemon:View_proxy_controller>) configx)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .socket .in .listen  configx)))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-listening (o <daemon:View_proxy_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .connect .out .listening )
        (set! (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Listening))))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-connected (o <daemon:View_proxy_controller>) ws)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Listening))
      (let ()
        *unspecified*
        (action o .connect .out .connected )
        (set! (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Listening)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-error (o <daemon:View_proxy_controller>) ws e)
  (cond ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .connect .out .error  e)))
    ((and (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle))) (not (not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Idle)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-message (o <daemon:View_proxy_controller>) ws msg)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .data2event .in .unwrap  msg))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-disconnect (o <daemon:View_proxy_controller>) ws msg)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (let ((foo *unspecified*))
        *unspecified*
        (set! foo (cons 'v  (log o "View disconnect=~s\n" msg)))
        (action o .connect .out .disconnect  msg)
        (set! (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Listening))))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-wrapped (o <daemon:View_proxy_controller>) data)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .socket .in .send  data))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-request (o <daemon:View_proxy_controller>) request)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .view .out .request  request))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-selected (o <daemon:View_proxy_controller>) selection)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .view .out .selected  selection))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-index_selected (o <daemon:View_proxy_controller>) selection)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .view .out .index_selected  selection))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-back (o <daemon:View_proxy_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .view .out .back ))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-event (o <daemon:View_proxy_controller>) event)
  (cond ((eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected))
      (action o .view .out .event  event))
    ((not (eq? (.state o) (assoc-ref daemon:View_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

;; (use-modules (daemon:View_data2event))

(define daemon:Editor_proxy_controller:State:alist
  '((Idle . State_Idle)
    (Listening . State_Listening)
    (Connected . State_Connected)))

(define-class <daemon:Editor_proxy_controller> (<dzn:component>)
  (config #:accessor .config #:init-form *unspecified*)
  (state #:accessor .state #:init-form (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle))
  (out_editor #:accessor .out_editor #:init-value #f #:init-keyword #:out_editor)
  (out_connect #:accessor .out_connect #:init-value #f #:init-keyword #:out_connect)
  (editor #:accessor .editor #:init-form (make <daemon:Ieditor>) #:init-keyword #:editor)
  (connect #:accessor .connect #:init-form (make <daemon:Iconnect>) #:init-keyword #:connect)
  (socket #:accessor .socket #:init-form (make <transport:Iwebsocket>) #:init-keyword #:socket)
  (data2event #:accessor .data2event #:init-form (make <daemon:Ieditor_data2event>) #:init-keyword #:data2event))

(define-method (initialize (o <daemon:Editor_proxy_controller>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.editor o)
    (make <daemon:Ieditor>
      #:in (make <daemon:Ieditor.in>
        #:name "editor"
        #:self o
        #:go_to_location (lambda args (call-in o (lambda _ (apply editor-go_to_location (cons o args))) `(,(.editor o) "go_to_location"))))
      #:out (make <daemon:Ieditor.out>)))
  (set! (.connect o)
    (make <daemon:Iconnect>
      #:in (make <daemon:Iconnect.in>
        #:name "connect"
        #:self o
        #:setup (lambda args (call-in o (lambda _ (apply connect-setup (cons o args))) `(,(.connect o) "setup"))))
      #:out (make <daemon:Iconnect.out>)))
  (set! (.socket o)
    (make <transport:Iwebsocket>
      #:in (make <transport:Iwebsocket.in>)
      #:out (make <transport:Iwebsocket.out>
        #:name "socket"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply socket-listening (cons o args))) `(,(.socket o) "listening")))
        #:connected (lambda args (call-out o (lambda _ (apply socket-connected (cons o args))) `(,(.socket o) "connected")))
        #:error (lambda args (call-out o (lambda _ (apply socket-error (cons o args))) `(,(.socket o) "error")))
        #:message (lambda args (call-out o (lambda _ (apply socket-message (cons o args))) `(,(.socket o) "message")))
        #:disconnect (lambda args (call-out o (lambda _ (apply socket-disconnect (cons o args))) `(,(.socket o) "disconnect"))))))
  (set! (.data2event o)
    (make <daemon:Ieditor_data2event>
      #:in (make <daemon:Ieditor_data2event.in>)
      #:out (make <daemon:Ieditor_data2event.out>
        #:name "data2event"
        #:self o
        #:wrapped (lambda args (call-out o (lambda _ (apply data2event-wrapped (cons o args))) `(,(.data2event o) "wrapped")))))))

(define-method (editor-go_to_location (o <daemon:Editor_proxy_controller>) loc)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected))
      (action o .data2event .in .wrap  "go_to" loc))
    ((and (not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected))) (not (not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (connect-setup (o <daemon:Editor_proxy_controller>) configx)
  (cond ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .socket .in .listen  configx)))
    ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-listening (o <daemon:Editor_proxy_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .connect .out .listening )
        (set! (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Listening))))
    ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-connected (o <daemon:Editor_proxy_controller>) ws)
  (cond ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Listening))
      (let ()
        *unspecified*
        (action o .connect .out .connected )
        (set! (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected))))
    ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Listening)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-error (o <daemon:Editor_proxy_controller>) ws e)
  (cond ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle)))
      *unspecified*)
    ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle))
      (let ()
        *unspecified*
        (action o .connect .out .error  e)))
    ((and (not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle))) (not (not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Idle)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-message (o <daemon:Editor_proxy_controller>) ws msg)
  (cond ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected))
      (action o .data2event .in .unwrap  msg))
    ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (socket-disconnect (o <daemon:Editor_proxy_controller>) ws msg)
  (cond ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected))
      (let ()
        *unspecified*
        (action o .connect .out .disconnect  msg)
        (set! (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Listening))))
    ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (data2event-wrapped (o <daemon:Editor_proxy_controller>) data)
  (cond ((eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected))
      (action o .socket .in .send  data))
    ((not (eq? (.state o) (assoc-ref daemon:Editor_proxy_controller:State:alist 'Connected)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

;; (use-modules (daemon:Editor_data2event))

;; (use-modules (daemon:Verify2event))

;; (use-modules (daemon:Routing))

;; (use-modules (daemon:Data))

(define daemon:Store_controller:State:alist
  '((Idle . State_Idle)
    (Active . State_Active)
    (Busy . State_Busy)))

(define-class <daemon:Store_controller> (<dzn:component>)
  (state #:accessor .state #:init-form (assoc-ref daemon:Store_controller:State:alist 'Idle))
  (reply-bool #:accessor .reply-bool #:init-value *unspecified*)
  (out_store #:accessor .out_store #:init-value #f #:init-keyword #:out_store)
  (store #:accessor .store #:init-form (make <daemon:Istore>) #:init-keyword #:store)
  (dz #:accessor .dz #:init-form (make <daemon:Idzn>) #:init-keyword #:dz)
  (data #:accessor .data #:init-form (make <daemon:Idata>) #:init-keyword #:data))

(define-method (initialize (o <daemon:Store_controller>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.store o)
    (make <daemon:Istore>
      #:in (make <daemon:Istore.in>
        #:name "store"
        #:self o
        #:setup (lambda args (call-in o (lambda _ (apply store-setup (cons o args))) `(,(.store o) "setup")))
        #:command (lambda args (call-in o (lambda _ (apply store-command (cons o args))) `(,(.store o) "command")))
        #:request (lambda args (call-in o (lambda _ (apply store-request (cons o args))) `(,(.store o) "request")))
        #:back (lambda args (call-in o (lambda _ (apply store-back (cons o args))) `(,(.store o) "back")))
        #:event (lambda args (call-in o (lambda _ (apply store-event (cons o args))) `(,(.store o) "event")))
        #:get_selection (lambda args (call-in o (lambda _ (apply store-get_selection (cons o args))) `(,(.store o) "get_selection")))
        #:get_location (lambda args (call-in o (lambda _ (apply store-get_location (cons o args))) `(,(.store o) "get_location"))))
      #:out (make <daemon:Istore.out>)))
  (set! (.dz o)
    (make <daemon:Idzn>
      #:in (make <daemon:Idzn.in>)
      #:out (make <daemon:Idzn.out>
        #:name "dz"
        #:self o
        #:result (lambda args (call-out o (lambda _ (apply dz-result (cons o args))) `(,(.dz o) "result"))))))
  (set! (.data o)
    (make <daemon:Idata>
      #:in (make <daemon:Idata.in>)
      #:out (make <daemon:Idata.out>
        #:name "data"
        #:self o))))

(define-method (store-setup (o <daemon:Store_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Idle))
      (set! (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active)))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Idle)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (store-command (o <daemon:Store_controller>) command)
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active))
      (let ()
        *unspecified*
        (action o .data .in .store_command  command)
        (action o .dz .in .command  command)
        (set! (.state o) (assoc-ref daemon:Store_controller:State:alist 'Busy))))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (store-request (o <daemon:Store_controller>) notification)
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active))
      (let ((tmp *unspecified*))
        *unspecified*
        (set! tmp (cons 'v  *unspecified*))
        (action o .data .in .request  notification tmp)
        (action o .store .out .update  (cdr tmp))))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (store-back (o <daemon:Store_controller>))
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active))
      (let ((command *unspecified*))
        *unspecified*
        (set! command (cons 'v  *unspecified*))
        (action o .data .in .get_command_simulate_back  command)
        (action o .dz .in .command  (cdr command))
        (set! (.state o) (assoc-ref daemon:Store_controller:State:alist 'Busy))))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (store-event (o <daemon:Store_controller>) event)
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active))
      (let ((command *unspecified*))
        *unspecified*
        (set! command (cons 'v  *unspecified*))
        (action o .data .in .get_command_simulate  event command)
        (action o .dz .in .command  (cdr command))
        (set! (.state o) (assoc-ref daemon:Store_controller:State:alist 'Busy))))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (store-get_selection (o <daemon:Store_controller>) selection)
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active))
      (let ((valid *unspecified*))
        *unspecified*
        (set! valid (cons 'v  (action o .data .in .get_selection  selection)))
        (begin (set! (.reply-bool o) (cdr valid)) )))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  (.reply-bool o))

(define-method (store-get_location (o <daemon:Store_controller>) selection loc)
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active))
      (let ()
        *unspecified*
        (action o .data .in .get_location  selection loc)))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (dz-result (o <daemon:Store_controller>) data)
  (cond ((eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Busy))
      (let ((tmp *unspecified*))
        *unspecified*
        (set! tmp (cons 'v  *unspecified*))
        (action o .data .in .store_result  data tmp)
        (action o .store .out .result  (cdr tmp))
        (set! (.state o) (assoc-ref daemon:Store_controller:State:alist 'Active))))
    ((not (eq? (.state o) (assoc-ref daemon:Store_controller:State:alist 'Busy)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

;; (use-modules (daemon:Dzn_proxy))

(define-class <daemon:Command_proxy> (<dzn:system>)
  (controller #:accessor .controller)
  (data2event #:accessor .data2event)
  (transprt #:accessor .transprt)
  (command #:accessor .command #:init-keyword #:command)
  (connect #:accessor .connect #:init-keyword #:connect))

(define-method (initialize (o <daemon:Command_proxy>) args)
  (next-method)
  (set! (.controller o) (make <daemon:Command_proxy_controller> #:locator (.locator o) #:parent o #:name "controller"))
  (set! (.data2event o) (make <daemon:Command_data2event> #:locator (.locator o) #:parent o #:name "data2event"))
  (set! (.transprt o) (make <transport:Transport_system> #:locator (.locator o) #:parent o #:name "transprt"))
  (set! (.command o) (.command (.controller o)))
  (set! (.connect o) (.connect (.controller o)))
  (set! (.out (.command o)) (make <daemon:Icommand.out>))
  (set! (.out (.connect o)) (make <daemon:Iconnect.out>))
  (dzn:connect  (.command_data2event (.data2event o))  (.data2event (.controller o)))
  (dzn:connect  (.websocket_transport (.transprt o))  (.socket (.controller o)))
  (dzn:rank (.command o) 0)
  (dzn:rank (.connect o) 0))

(define-class <daemon:View_proxy> (<dzn:system>)
  (controller #:accessor .controller)
  (data2event #:accessor .data2event)
  (transprt #:accessor .transprt)
  (view #:accessor .view #:init-keyword #:view)
  (connect #:accessor .connect #:init-keyword #:connect))

(define-method (initialize (o <daemon:View_proxy>) args)
  (next-method)
  (set! (.controller o) (make <daemon:View_proxy_controller> #:locator (.locator o) #:parent o #:name "controller"))
  (set! (.data2event o) (make <daemon:View_data2event> #:locator (.locator o) #:parent o #:name "data2event"))
  (set! (.transprt o) (make <transport:Transport_system> #:locator (.locator o) #:parent o #:name "transprt"))
  (set! (.view o) (.view (.controller o)))
  (set! (.connect o) (.connect (.controller o)))
  (set! (.out (.view o)) (make <daemon:Iview.out>))
  (set! (.out (.connect o)) (make <daemon:Iconnect.out>))
  (dzn:connect  (.view_data2event (.data2event o))  (.data2event (.controller o)))
  (dzn:connect  (.websocket_transport (.transprt o))  (.socket (.controller o)))
  (dzn:rank (.view o) 0)
  (dzn:rank (.connect o) 0))

(define-class <daemon:Editor_proxy> (<dzn:system>)
  (controller #:accessor .controller)
  (data2event #:accessor .data2event)
  (transprt #:accessor .transprt)
  (editor #:accessor .editor #:init-keyword #:editor)
  (connect #:accessor .connect #:init-keyword #:connect))

(define-method (initialize (o <daemon:Editor_proxy>) args)
  (next-method)
  (set! (.controller o) (make <daemon:Editor_proxy_controller> #:locator (.locator o) #:parent o #:name "controller"))
  (set! (.data2event o) (make <daemon:Editor_data2event> #:locator (.locator o) #:parent o #:name "data2event"))
  (set! (.transprt o) (make <transport:Transport_system> #:locator (.locator o) #:parent o #:name "transprt"))
  (set! (.editor o) (.editor (.controller o)))
  (set! (.connect o) (.connect (.controller o)))
  (set! (.out (.editor o)) (make <daemon:Ieditor.out>))
  (set! (.out (.connect o)) (make <daemon:Iconnect.out>))
  (dzn:connect  (.editor_data2event (.data2event o))  (.data2event (.controller o)))
  (dzn:connect  (.websocket_transport (.transprt o))  (.socket (.controller o)))
  (dzn:rank (.editor o) 0)
  (dzn:rank (.connect o) 0))

(define-class <daemon:Store> (<dzn:system>)
  (controller #:accessor .controller)
  (dz #:accessor .dz)
  (data #:accessor .data)
  (store #:accessor .store #:init-keyword #:store))

(define-method (initialize (o <daemon:Store>) args)
  (next-method)
  (set! (.controller o) (make <daemon:Store_controller> #:locator (.locator o) #:parent o #:name "controller"))
  (set! (.dz o) (make <daemon:Dzn_proxy> #:locator (.locator o) #:parent o #:name "dz"))
  (set! (.data o) (make <daemon:Data> #:locator (.locator o) #:parent o #:name "data"))
  (set! (.store o) (.store (.controller o)))
  (set! (.out (.store o)) (make <daemon:Istore.out>))
  (dzn:connect  (.dz (.dz o))  (.dz (.controller o)))
  (dzn:connect  (.data (.data o))  (.data (.controller o)))
  (dzn:rank (.store o) 0))

(define-class <daemon:Daemon> (<dzn:system>)
  (controller #:accessor .controller)
  (store #:accessor .store)
  (command_proxy #:accessor .command_proxy)
  (view_proxy #:accessor .view_proxy)
  (editor_proxy #:accessor .editor_proxy)
  (routing #:accessor .routing)
  (start #:accessor .start #:init-keyword #:start))

(define-method (initialize (o <daemon:Daemon>) args)
  (next-method)
  (set! (.controller o) (make <daemon:Daemon_controller> #:locator (.locator o) #:parent o #:name "controller"))
  (set! (.store o) (make <daemon:Store> #:locator (.locator o) #:parent o #:name "store"))
  (set! (.command_proxy o) (make <daemon:Command_proxy> #:locator (.locator o) #:parent o #:name "command_proxy"))
  (set! (.view_proxy o) (make <daemon:View_proxy> #:locator (.locator o) #:parent o #:name "view_proxy"))
  (set! (.editor_proxy o) (make <daemon:Editor_proxy> #:locator (.locator o) #:parent o #:name "editor_proxy"))
  (set! (.routing o) (make <daemon:Routing> #:locator (.locator o) #:parent o #:name "routing"))
  (set! (.start o) (.start (.controller o)))
  (set! (.out (.start o)) (make <daemon:Istart.out>))
  (dzn:connect  (.store (.store o))  (.store (.controller o)))
  (dzn:connect  (.view (.view_proxy o))  (.view (.controller o)))
  (dzn:connect  (.connect (.view_proxy o))  (.vconnect (.controller o)))
  (dzn:connect  (.command (.command_proxy o))  (.command (.controller o)))
  (dzn:connect  (.connect (.command_proxy o))  (.iconnect (.controller o)))
  (dzn:connect  (.editor (.editor_proxy o))  (.editor (.controller o)))
  (dzn:connect  (.connect (.editor_proxy o))  (.econnect (.controller o)))
  (dzn:connect  (.routing (.routing o))  (.routing (.controller o)))
  (dzn:rank (.start o) 0))
;;; version: 2.14.0
