;;; Generated by dzn code from dzn/transport/transport.dzn
(define-module (transport transport)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (transport transport_interface)
  #:use-module (transport Serialize)
  #:use-module (transport Websocket)
  #:duplicates (merge-generics)
  #:export (<transport:Transport>
    .transport
    .state
    .listening_
    <transport:Transport_system>
    .websocket_transport)
  #:re-export (.websocket
    .serialize
    <transport:Serialize>
    <transport:Websocket>))

(define true #t)
(define false #f)

;; (use-modules (transport:Serialize))

(define transport:Transport:State:alist
  '((Closed . State_Closed)
    (Opening . State_Opening)
    (Open . State_Open)
    (Closing . State_Closing)))

(define-class <transport:Transport> (<dzn:component>)
  (state #:accessor .state #:init-form (assoc-ref transport:Transport:State:alist 'Closed))
  (listening_ #:accessor .listening_ #:init-form false)
  (out_transport #:accessor .out_transport #:init-value #f #:init-keyword #:out_transport)
  (transport #:accessor .transport #:init-form (make <transport:Iwebsocket>) #:init-keyword #:transport)
  (websocket #:accessor .websocket #:init-form (make <transport:Iwebsocket>) #:init-keyword #:websocket)
  (serialize #:accessor .serialize #:init-form (make <transport:Iserialize>) #:init-keyword #:serialize))

(define-method (initialize (o <transport:Transport>) args)
  (next-method o (cons* #:flushes? #t args))
  (set! (.transport o)
    (make <transport:Iwebsocket>
      #:in (make <transport:Iwebsocket.in>
        #:name "transport"
        #:self o
        #:listen (lambda args (call-in o (lambda _ (apply transport-listen (cons o args))) `(,(.transport o) "listen")))
        #:open (lambda args (call-in o (lambda _ (apply transport-open (cons o args))) `(,(.transport o) "open")))
        #:close (lambda args (call-in o (lambda _ (apply transport-close (cons o args))) `(,(.transport o) "close")))
        #:send (lambda args (call-in o (lambda _ (apply transport-send (cons o args))) `(,(.transport o) "send")))
        #:get (lambda args (call-in o (lambda _ (apply transport-get (cons o args))) `(,(.transport o) "get"))))
      #:out (make <transport:Iwebsocket.out>)))
  (set! (.websocket o)
    (make <transport:Iwebsocket>
      #:in (make <transport:Iwebsocket.in>)
      #:out (make <transport:Iwebsocket.out>
        #:name "websocket"
        #:self o
        #:listening (lambda args (call-out o (lambda _ (apply websocket-listening (cons o args))) `(,(.websocket o) "listening")))
        #:connected (lambda args (call-out o (lambda _ (apply websocket-connected (cons o args))) `(,(.websocket o) "connected")))
        #:error (lambda args (call-out o (lambda _ (apply websocket-error (cons o args))) `(,(.websocket o) "error")))
        #:message (lambda args (call-out o (lambda _ (apply websocket-message (cons o args))) `(,(.websocket o) "message")))
        #:disconnect (lambda args (call-out o (lambda _ (apply websocket-disconnect (cons o args))) `(,(.websocket o) "disconnect"))))))
  (set! (.serialize o)
    (make <transport:Iserialize>
      #:in (make <transport:Iserialize.in>)
      #:out (make <transport:Iserialize.out>
        #:name "serialize"
        #:self o
        #:message (lambda args (call-out o (lambda _ (apply serialize-message (cons o args))) `(,(.serialize o) "message")))
        #:data (lambda args (call-out o (lambda _ (apply serialize-data (cons o args))) `(,(.serialize o) "data")))
        #:pong (lambda args (call-out o (lambda _ (apply serialize-pong (cons o args))) `(,(.serialize o) "pong")))))))

(define-method (transport-listen (o <transport:Transport>) config)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed))
      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
        (set! (.listening_ o) true)
        (action o .websocket .in .listen  config)))
    ((not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (transport-open (o <transport:Transport>) url)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed))
      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
        (set! (.listening_ o) false)
        (action o .websocket .in .open  url)))
    ((not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (transport-close (o <transport:Transport>))
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed))
      *unspecified*)
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref transport:Transport:State:alist 'Closed))
        (set! (.listening_ o) false)
        (action o .websocket .in .close )))
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))
      (let ()
        *unspecified*
        (if (.listening_ o)
          (set! (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
          (set! (.state o) (assoc-ref transport:Transport:State:alist 'Closed)))
        (action o .websocket .in .close )))
    ((and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))) (and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))) (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed)))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (transport-send (o <transport:Transport>) msg)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))
      (action o .serialize .in .pack  msg))
    ((not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (transport-get (o <transport:Transport>) ws)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))
      (action o .websocket .in .get  ws))
    ((not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (websocket-listening (o <transport:Transport>))
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
      (action o .transport .out .listening ))
    ((not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (websocket-connected (o <transport:Transport>) ws)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref transport:Transport:State:alist 'Open))
        (action o .transport .out .connected  ws)))
    ((not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (websocket-error (o <transport:Transport>) ws e)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
      (let ()
        *unspecified*
        (set! (.state o) (assoc-ref transport:Transport:State:alist 'Closed))
        (action o .transport .out .error  ws e)))
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))
      (let ()
        *unspecified*
        (if (not (.listening_ o))
          (let ()
            *unspecified*
            (set! (.state o) (assoc-ref transport:Transport:State:alist 'Closing))
            (action o .transport .out .error  ws e)))))
    ((and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))) (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (websocket-message (o <transport:Transport>) ws msg)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))
      (action o .serialize .in .unpack  msg))
    ((not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open)))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (websocket-disconnect (o <transport:Transport>) ws msg)
  (cond (true
      (let ()
        *unspecified*
        (if (.listening_ o)
          (set! (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
          (set! (.state o) (assoc-ref transport:Transport:State:alist 'Closed)))
        (action o .transport .out .disconnect  ws msg)))
    (false
      (((compose .illegal .runtime) o))))
  *unspecified*)

(define-method (serialize-message (o <transport:Transport>) msg)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed))
      *unspecified*)
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
      *unspecified*)
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))
      (action o .websocket .in .send  msg))
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closing))
      *unspecified*)
    ((and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closing))) (and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))) (and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))) (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed))))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (serialize-data (o <transport:Transport>) data)
  (cond ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed))
      *unspecified*)
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))
      *unspecified*)
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))
      (action o .transport .out .message  0 data))
    ((eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closing))
      *unspecified*)
    ((and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closing))) (and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Open))) (and (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Opening))) (not (eq? (.state o) (assoc-ref transport:Transport:State:alist 'Closed))))))
      (((compose .illegal .runtime) o)))
    (else ((compose .illegal .runtime) o)))
  *unspecified*)

(define-method (serialize-pong (o <transport:Transport>))
  (cond (true
      (((compose .illegal .runtime) o))))
  *unspecified*)

;; (use-modules (transport:Websocket))

(define-class <transport:Transport_system> (<dzn:system>)
  (transport #:accessor .transport)
  (serialize #:accessor .serialize)
  (websocket #:accessor .websocket)
  (websocket_transport #:accessor .websocket_transport #:init-keyword #:websocket_transport))

(define-method (initialize (o <transport:Transport_system>) args)
  (next-method)
  (set! (.transport o) (make <transport:Transport> #:locator (.locator o) #:parent o #:name "transport"))
  (set! (.serialize o) (make <transport:Serialize> #:locator (.locator o) #:parent o #:name "serialize"))
  (set! (.websocket o) (make <transport:Websocket> #:locator (.locator o) #:parent o #:name "websocket"))
  (set! (.websocket_transport o) (.transport (.transport o)))
  (set! (.out (.websocket_transport o)) (make <transport:Iwebsocket.out>))
  (dzn:connect  (.serialize (.serialize o))  (.serialize (.transport o)))
  (dzn:connect  (.websocket (.websocket o))  (.websocket (.transport o)))
  (dzn:rank (.websocket_transport o) 0))
;;; version: 2.14.0
