;;; Dezyne-IDE --- An IDE for Dezyne
;;;
;;; Copyright © 2020,2021 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;;
;;; This file is part of Dezyne-IDE.
;;;
;;; Dezyne-IDE is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (daemon Editor_data2event)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (daemon daemon_interface)
  #:use-module (transport libenvelope)
  #:duplicates (merge-generics)
  #:export (<daemon:Editor_data2event>
            .editor_data2event))

(define-class <daemon:Editor_data2event> (<dzn:component>)
  (editor_data2event #:accessor .editor_data2event #:init-form (make <daemon:Ieditor_data2event>) #:init-keyword #:editor_data2event))

(define-method (initialize (o <daemon:Editor_data2event>) args)
  (next-method)
  (set! (.editor_data2event o)
        (make <daemon:Ieditor_data2event>
          #:in (make <daemon:Ieditor_data2event.in>
                 #:name "editor_data2event"
                 #:self o
                 #:wrap (lambda args (call-in o (lambda _ (apply editor_data2event-wrap (cons o args))) `(,(.editor_data2event o) wrap)))#:unwrap (lambda args (call-in o (lambda _ (apply editor_data2event-unwrap (cons o args))) `(,(.editor_data2event o) unwrap))))
          #:out (make <daemon:Ieditor_data2event.out>))))


(define-method (editor_data2event-wrap (o <daemon:Editor_data2event>) label data)
  (action o .editor_data2event .out .wrapped (libenvelope:wrap label data)))

(define-method (editor_data2event-unwrap (o <daemon:Editor_data2event>) data)
  (let ((label (libenvelope:label data))
        (data (libenvelope:data data)))
    (case label
      ((wrapped) (action o .editor_data2event .out .wrapped data))
      (else (stderr "Editor_editor_data2event: no such label: ~s\n" label)
            (action o .editor_data2event .out .error)))))
