;;; Verum-Dezyne --- An IDE for Dezyne
;;;
;;; Copyright © 2019 Rob Wieringa <Rob.Wieringa@verum.com>
;;; Copyright © 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2020 Paul Hoogendijk <paul.hoogendijk@verum.com>
;;;
;;; This file is part of Verum-Dezyne.
;;;
;;; Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (command Daemon_data2event)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (command command)
  #:use-module (transport libenvelope)
  #:duplicates (merge-generics)
  #:export (<command:Daemon_data2event>
            .data2event))

(define-class <command:Daemon_data2event> (<dzn:component>)
  (data2event #:accessor .data2event #:init-form (make <command:Idaemon_data2event>) #:init-keyword #:data2event))

(define-method (initialize (o <command:Daemon_data2event>) args)
  (next-method)
  (set! (.data2event o)
    (make <command:Idaemon_data2event>
      #:in (make <command:Idaemon_data2event.in>
        #:name "data2event"
        #:self o
        #:wrap (lambda args (call-in o (lambda _ (apply data2event-wrap (cons o args))) `(,(.data2event o) wrap)))
        #:data2event (lambda args (call-in o (lambda _ (apply data2event-data2event (cons o args))) `(,(.data2event o) data2event))))
      #:out (make <command:Idaemon_data2event.out>))))


(define-method (data2event-wrap (o <command:Daemon_data2event>) label data)
  (action o .data2event .out .envelope (libenvelope:wrap label data)))

(define-method (data2event-data2event (o <command:Daemon_data2event>) data)
  (let ((label (libenvelope:label data))
        (data (libenvelope:data data)))
    (case label
      ((result) (action o .data2event .out .result data))
      ((error) (action o .data2event .out .error data))
      ((envelope) (action o .data2event .out .envelope data))
      (else (stderr "View_data2event: no such label: ~s\n" label)
            (action o .data2event .out .error)))))
