;;; Verum-Dezyne --- An IDE for Dezyne
;;;
;;; Copyright © 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;;
;;; This file is part of Verum-Dezyne.
;;;
;;; Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.

(define-module (ide config)
  #:export (%datadir
            %datarootdir
            %daemon-config-file
            %default-editor-port
            %default-http-port
            %default-ide-port
            %default-view-port
            %editor-port
            %http-port
            %ide-port
            %imports
            %pkgdatadir
            %prefix
            %queue-size
            %queue-size-defer
            %queue-size-external
            %user-cache-dir
            %user-config-dir
            %user-runtime-dir
            %version
            %view-port
            %web-root))

(define %imports
  '())

(define %prefix
  (or (and (getenv "IDE_UNINSTALLED") (getenv "IDE_PREFIX"))
      "/gnu/store/6ldc1ilzm75rllq9d9i4r1r6fhsk6wvz-verum-dezyne-mingw-2.18.0"))

(define %datadir
  (or (and (getenv "IDE_UNINSTALLED") %prefix)
      "/gnu/store/6ldc1ilzm75rllq9d9i4r1r6fhsk6wvz-verum-dezyne-mingw-2.18.0/share"))

(define %datarootdir
  (or (and (getenv "IDE_UNINSTALLED") %prefix)
      "/gnu/store/6ldc1ilzm75rllq9d9i4r1r6fhsk6wvz-verum-dezyne-mingw-2.18.0/share"))

(define %pkgdatadir
  (or (and (getenv "IDE_UNINSTALLED") %prefix)
      (getenv "IDE_DATADIR")
      "/gnu/store/6ldc1ilzm75rllq9d9i4r1r6fhsk6wvz-verum-dezyne-mingw-2.18.0/share/verum-dezyne"))

(define %user-cache-dir
  (string-append (or (getenv "XDG_CACHE_HOME")
                     (string-append (getenv "HOME") "/.cache"))
                 "/dzn"))

(define %user-config-dir
  (string-append (or (getenv "XDG_CONFIG_HOME")
                     (string-append (getenv "HOME") "/.config"))
                 "/dzn"))

(define %user-runtime-dir
  (string-append (or (getenv "XDG_RUNTIME_DIR")
                     (and (defined? 'getuid)
                          (let ((dir (format #f "/run/user/~s" (getuid))))
                            (and (file-exists? dir)
                                 dir)))
                     (getenv "XDG_CACHE_HOME")
                     (string-append (getenv "HOME") "/.cache"))
                 "/dzn"))

(define %daemon-config-file
  (string-append %user-config-dir "/daemon.scm"))

(define %web-root
  (string-append %pkgdatadir "/dzn"))

(define %version
  "2.18.0")


;;;
;;; Defaults.
;;;
(define %default-editor-port
  3003)

(define %default-http-port
  3000)

(define %default-ide-port
  3001)

(define %default-view-port
  3002)

(define %editor-port
  3003)

(define %http-port
  3000)

(define %ide-port
  3001)

(define %view-port
  3002)

;;; The component queue.
(define %queue-size 3)

;;; The defer queue.
(define %queue-size-defer 2)

;;; The external queue.
(define %queue-size-external 1)
