// Generated by dzn code from dzn/transport/transport.dzn
// Verum-Dezyne --- An IDE for Dezyne
//
// Copyright © 2019 Rob Wieringa <Rob.Wieringa@verum.com>
// Copyright © 2020 Paul Hoogendijk <paul.hoogendijk@verum.com>
//
// This file is part of Verum-Dezyne.
//
// Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
// All rights reserved.

function node_p () {return typeof module !== 'undefined';}
function have_dzn_p () {return typeof (dzn) !== 'undefined' && dzn;}

if (node_p ()) {
  // nodejs
  module.paths.unshift (__dirname);
  dzn_require = require;
  dzn = have_dzn_p () ? dzn : require (__dirname + '/runtime');
  dzn = dzn ||   {};
  dzn.dzn = dzn.dzn ||   {};
} else {
  // browser
  dzn_require = function ()   {return   {};};
  dzn = have_dzn_p () ? dzn :   {};
  /* Add to your html something like
  <script src="js/dzn/runtime.js"></script>
  <script src="js/transport/transport.js"></script>
  */
}

if (node_p ()) {
  // nodejs
  dzn.extend (dzn, require ('transport/Serialize'));
} else {
  // browser
  /* Add to your html something like
  <script src="js/transport/Serialize.js"></script>
  */
}

dzn = dzn || {};
dzn.transport = dzn.transport || {};

if (node_p ()) {dzn.extend (dzn, dzn_require ('transport/transport_interface'));}
if (node_p ()) {dzn.extend (dzn, dzn_require ('transport/Serialize'));}
if (node_p ()) {dzn.extend (dzn, dzn_require ('transport/Websocket'));}

dzn.transport.Transport = function (locator, meta) {
  dzn.runtime.init (this, locator, meta);
  this._dzn.meta.ports = ['transport', 'websocket', 'serialize'];
  this._dzn.flushes = true;

  this.State =   {Closed: 'State:Closed',Opening: 'State:Opening',Open: 'State:Open',Closing: 'State:Closing'};
  this.state =  this.State.Closed;
  this.listening_ =  false;
  this.transport = new dzn.transport.Iwebsocket(  {provides:   {name: 'transport', component: this}, requires:   {}});
  this.websocket = new dzn.transport.Iwebsocket(  {provides:   {}, requires:   {name: 'websocket', component: this}});
  this.serialize = new dzn.transport.Iserialize(  {provides:   {}, requires:   {name: 'serialize', component: this}});

  this.transport.in.listen = function(config)  {
      if (this.state == this.State.Closed) 
        {
          this.state = this.State.Opening;
          this.listening_ = true;
          this.websocket.in.listen(config);
        }
      else
      if (!(this.state == this.State.Closed)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.transport.in.open = function(url)  {
      if (this.state == this.State.Closed) 
        {
          this.state = this.State.Opening;
          this.listening_ = false;
          this.websocket.in.open(url);
        }
      else
      if (!(this.state == this.State.Closed)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.transport.in.close = function()  {
      if (this.state == this.State.Closed)   {
          /* skip */
        }
      else
      if (this.state == this.State.Opening) 
        {
          this.state = this.State.Closed;
          this.listening_ = false;
          this.websocket.in.close();
        }
      else
      if (this.state == this.State.Open) 
        {
            {
              if (this.listening_) this.state = this.State.Opening; else this.state = this.State.Closed;
            }
          this.websocket.in.close();
        }
      else
      if (!(this.state == this.State.Open) && (!(this.state == this.State.Opening) && !(this.state == this.State.Closed))) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.transport.in.send = function(msg)  {
      if (this.state == this.State.Open) this.serialize.in.pack(msg);
      else
      if (!(this.state == this.State.Open)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.transport.in.get = function(ws)  {
      if (this.state == this.State.Open) this.websocket.in.get(ws);
      else
      if (!(this.state == this.State.Open)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.websocket.out.listening = function()  {
      if (this.state == this.State.Opening) this.transport.out.listening();
      else
      if (!(this.state == this.State.Opening)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.websocket.out.connected = function(ws)  {
      if (this.state == this.State.Opening) 
        {
          this.state = this.State.Open;
          this.transport.out.connected(ws);
        }
      else
      if (!(this.state == this.State.Opening)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.websocket.out.error = function(ws,e)  {
      if (this.state == this.State.Opening) 
        {
          this.state = this.State.Closed;
          this.transport.out.error(ws,e);
        }
      else
      if (this.state == this.State.Open) 
        {
            {
              if (!this.listening_) 
                {
                  this.state = this.State.Closing;
                  this.transport.out.error(ws,e);
                }
            }
        }
      else
      if (!(this.state == this.State.Open) && !(this.state == this.State.Opening)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.websocket.out.message = function(ws,msg)  {
      if (this.state == this.State.Open) this.serialize.in.unpack(msg);
      else
      if (!(this.state == this.State.Open)) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.websocket.out.disconnect = function(ws,msg)  {

        {
            {
              if (this.listening_) this.state = this.State.Opening; else this.state = this.State.Closed;
            }
          this.transport.out.disconnect(ws,msg);
        }
    }

  this.serialize.out.message = function(msg)  {
      if (this.state == this.State.Closed)   {
          /* skip */
        }
      else
      if (this.state == this.State.Opening)   {
          /* skip */
        }
      else
      if (this.state == this.State.Open) this.websocket.in.send(msg);
      else
      if (this.state == this.State.Closing)   {
          /* skip */
        }
      else
      if (!(this.state == this.State.Closing) && (!(this.state == this.State.Open) && (!(this.state == this.State.Opening) && !(this.state == this.State.Closed)))) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.serialize.out.data = function(data)  {
      if (this.state == this.State.Closed)   {
          /* skip */
        }
      else
      if (this.state == this.State.Opening)   {
          /* skip */
        }
      else
      if (this.state == this.State.Open) this.transport.out.message(0,data);
      else
      if (this.state == this.State.Closing)   {
          /* skip */
        }
      else
      if (!(this.state == this.State.Closing) && (!(this.state == this.State.Open) && (!(this.state == this.State.Opening) && !(this.state == this.State.Closed)))) this._dzn.rt.illegal();
      else
      this._dzn.rt.illegal();
    }

  this.serialize.out.pong = function()  {
      this._dzn.rt.illegal();
    }

  this._dzn.rt.bind (this);
};

if (node_p ()) {
  // nodejs
  module.exports = dzn;
}

if (node_p ()) {
  // nodejs
  dzn.extend (dzn, require ('transport/Websocket'));
} else {
  // browser
  /* Add to your html something like
  <script src="js/transport/Websocket.js"></script>
  */
}

function node_p () {return typeof module !== 'undefined';}
function have_dzn_p () {return typeof (dzn) !== 'undefined' && dzn;}

if (node_p ()) {
  // nodejs
  module.paths.unshift (__dirname);
  dzn_require = require;
  dzn = have_dzn_p () ? dzn : require (__dirname + '/dzn/runtime');
} else {
  // browser
  dzn_require = function ()   {return   {};};
  dzn = have_dzn_p () ? dzn :   {};
  /* Add to your html something like
  <script src="js/transport/transport.js"></script>
  */
}

dzn = dzn || {};
dzn.transport = dzn.transport || {};

if (node_p ()) {dzn.extend (dzn, dzn_require ('transport/transport_interface'));}
if (node_p ()) {dzn.extend (dzn, dzn_require ('transport/Serialize'));}
if (node_p ()) {dzn.extend (dzn, dzn_require ('transport/Websocket'));}

dzn.transport.Transport_system = function (locator, meta) {
  dzn.runtime.init (this, locator, meta);
  this._dzn.meta.ports = ['websocket_transport'];
  this._dzn.meta.children = ['transport','serialize','websocket'];

  this.transport = new dzn.transport.Transport(this._dzn.locator,   {parent: this, name: 'transport'});
  this.serialize = new dzn.transport.Serialize(this._dzn.locator,   {parent: this, name: 'serialize'});
  this.websocket = new dzn.transport.Websocket(this._dzn.locator,   {parent: this, name: 'websocket'});
  this.websocket_transport = this.transport.transport;
  dzn.connect(this.serialize.serialize, this.transport.serialize);
  dzn.connect(this.websocket.websocket, this.transport.websocket);
};

if (node_p ()) {
  module.exports = dzn;
}
//version: 2.18.0.rc3
