All rights reserved.
//
//
// Commentary:
//
// This header provides a simplistic implementation of an
// "exception_context" struct for use with the C++ exception-wrapper
// code generator:
//
// dzn code --calling-context=exception_context --language=c++-exception-wrappers ...
//
// See also test/all/exception_wrapper.
//
// Code:

#include <iostream>
#include <queue>

struct exception_context
{
  std::queue<std::exception_ptr> qe;
  void operator()(){
    if(qe.size())
      std::rethrow_exception(qe.front());
  }
  void extend(const std::exception_ptr e) {
    qe.push(e);
  }
  static void report(const std::exception& e) {
    std::clog << "exception." << e.what() << std::endl;
  }
};
//version: 2.14.1
