// dzn-runtime -- Dezyne runtime library
//
// Copyright © 2016, 2019 Jan Nieuwenhuizen <janneke@gnu.org>
// Copyright © 2016 Rob Wieringa <rob@dezyne.org>
// Copyright © 2018 Filip Toman <filip.toman@verum.com>
// Copyright © 2016 Rutger van Beusekom <rutger@dezyne.org>
//
// This file is part of dzn-runtime.
//
// All rights reserved.
//
//
// Commentary:
//
// Code:

#ifndef DZN_LOCATOR_H
#define DZN_LOCATOR_H

#include <dzn/config.h>
#include <dzn/boolc90.h>
#include <dzn/runloc.h>
#include <dzn/mem.h>

void locator_init(locator* self);
locator* locator_clone(locator* self);
#if DZN_LOCATOR_SERVICES
int32_t map_copy(map_element* elt, void* dst);
void* locator_get(locator* self, char_t* key);
locator* locator_set(locator* self, char_t* key, void* value);
#endif /* DZN_LOCATOR_SERVICES */

#endif /* DZN_LOCATOR_H */
//version: 2.15.5
