// dzn-runtime -- Dezyne runtime library
//
// Copyright © 2018 Filip Toman <filip.toman@verum.com>
// Copyright © 2019 Jan Nieuwenhuizen <janneke@gnu.org>
//
// This file is part of dzn-runtime.
//
// All rights reserved.
//
//
// Commentary:
//
// Code:

#ifndef RUNLOC_H
#define RUNLOC_H

#include <dzn/boolc90.h>
#include <dzn/config.h>
#include <dzn/queue.h>

#if DZN_LOCATOR_SERVICES
#include <dzn/map.h>
#endif /* !DZN_LOCATOR_SERVICES */


typedef struct locator_t locator;
struct locator_t {
	void (*illegal)(void);

#if DZN_LOCATOR_SERVICES
  map services;
#endif /* DZN_LOCATOR_SERVICES */
};

typedef struct runtime_info_t runtime_info;
struct runtime_info_t{
  locator* lc;
  bool handling;
  bool performs_flush;
  runtime_info* deferred;
  queue q;
};

#endif /* RUNLOC_H */
//version: 2.16.5
