// dzn-runtime -- Dezyne runtime library
//
// Copyright © 2015 Paul Hoogendijk <paul@dezyne.org>
// Copyright © 2016 Rob Wieringa <rob@dezyne.org>
// Copyright © 2018 Filip Toman <filip.toman@verum.com>
// Copyright © 2016 Rutger van Beusekom <rutger@dezyne.org>
// Copyright © 2016, 2019 Jan Nieuwenhuizen <janneke@gnu.org>
//
// This file is part of dzn-runtime.
//
// All rights reserved.
//
//
// Commentary:
//
// Code:

#include <dzn/mem.h>
#include <assert.h>

#if (DZN_MISRA_C_2004==1)
#define MAX_SIZE 1048576
static uint8_t dzn_memory_array[MAX_SIZE];
static uint8_t* current_address = dzn_memory_array;


void*
dzn_calloc (size_t n, size_t size)
{
  uint8_t* res;
  assert(MAX_SIZE + dzn_memory_array - current_address >= n * size);
  res = current_address;

  current_address = &dzn_memory_array[n*size];
  return res;
}

void*
dzn_malloc(size_t size)
{
  return dzn_calloc((size_t) 1, size);
}

void
dzn_free(void* ptr)
{
  /*no freeing, automated */
  return;
}

#else /* !DZN_MISRA_C_2004 */
#include <stdlib.h>
#include <stdio.h>

void*
dzn_calloc (size_t n, size_t size)
{
  void* res;
  res = calloc(n, size);
  if (res==(void*)0)
  {
      assert (0);
  }
  return res;
}

void*
dzn_malloc(size_t size)
{
  return dzn_calloc(1, size);
}

void
dzn_free(void* ptr)
{
  free(ptr);
}
#endif /* DZN_MISRA_C_2004 */
//version: 2.17.7
