// dzn-runtime -- Dezyne runtime library
// Copyright © 2023 Jan Nieuwenhuizen <janneke@gnu.org>
//
// This file is part of dzn-runtime.
//
// All rights reserved.
//
//
// Commentary:
//
// Code:

#ifndef DZN_COROUTINE_H
#define DZN_COROUTINE_H

#include <dzn/config.h>
#if HAVE_LIBPTH
#include <pth.h>
typedef pth_t dzn_coroutine;
#else
typedef int dzn_coroutine;
#endif

typedef struct dzn_interface dzn_interface;
typedef void * (*dzn_coroutine_function) (void *);

int dzn_coroutine_init ();
dzn_coroutine dzn_coroutine_self ();
dzn_coroutine dzn_coroutine_create (dzn_coroutine_function function, void *data);
int dzn_coroutine_yield_to (dzn_coroutine coroutine);

long dzn_coroutine_id ();
int dzn_coroutine_set_id (long id);
void *dzn_coroutine_data ();
int dzn_coroutine_set_data (void *data);

#endif /* DZN_COROUTINE_H */
//version: 2.18.2
//version: 2.18.2
