function node_p () {return typeof module !== 'undefined';}

var ast2go = {

  toString: function (name) {
    if (ast.is_a(name, 'scope_name')) {
      return name.ids.join('.');
    }
    else return name;
  }
  ,
  last_name_p: function (name) {
    return function(o) {
      return o.name && o.name.ids && o.name.ids[o.name.ids.length-1] == name;
    };
  }
  ,
  calcSize: function (system, component) {
    var size = 0;
    function traverse(c) {
      size = size+1;
      if (c && ast.is_a (c, 'system')) {
        c.instances.elements.forEach(function(inst) {
          var sub = system.elements.find (ast2go.last_name_p (ast2go.type_name (inst)));
          traverse(sub);
        });
      }
    }
    traverse(component);
    return size;
  }
  ,
  type_name: function (o) {
    return ast2go.toString(o.type_name);
  }
  ,
  ast2go: function (root, sut) {
    var model = Object();
    model.linkFromPortIdProperty = 'fromPort';
    model.linkToPortIdProperty = 'toPort';

    function port_name_direction_p(name, direction) {
      return function (port) {
        return port.name == name && port.direction == direction;
      };
    }

    function findComps(name, scope, down) { // scope: array of namespaces
      if (!name || scope.length==0) return [];
      var names = name.split('.');
      var namespace = scope[scope.length-1];
      var found = namespace.elements.filter (ast2go.last_name_p (names[0]));
      if (found.length==0) {
        if (down) {
          return [];
        }
        else return findComps(name, scope.slice(0, -1), down);
      }
      var result = [];
      found.forEach(function(elt) {
        if (names.length > 1) {
          if (elt && ast.is_a(elt, 'namespace')) {
            var name1 = names.slice(1).join('.');
            var scope1 = scope.slice(); // copy
            scope1.push(elt);
            var found1 = findComps(name1, scope1, true);
            found1.forEach(function(f) { result.push(f); });
          }
        } else {
          elt.scope = scope;
          result.push(elt);
        }
      });
      return result;
    }

    function findComp(name, scope) { // scope: array of namespaces
      var found = findComps(name, scope, false);
      return found[0];
    }

    function getPortDir(comp, compName, portName) {
      var res = null;

      var type = '';
      var ext;

      var instance = comp.instances.elements.find (ast.field_eq_p ('name', compName));
      if (instance) {
        type = ast2go.type_name (instance);
        ext = false;
      }
      else {
        type = compName;
        ext = true;
      }

      var comp = findComp (type, comp.scope);
      if (comp) {
        if (comp.ports.elements.find (port_name_direction_p (portName, 'provides'))) {
          res = (ext?'out':'in');
        }
        else if (comp.ports.elements.find (port_name_direction_p (portName, 'requires'))) {
          res = (ext?'in':'out');
        }
      }
      return res;
    }

    function addDeflocs(scope) {
      scope = scope || [root];
      var namespace = scope[scope.length-1];
      namespace.elements.filter (ast.is_p ('namespace'))
        .map(function(ns) {
          scope.push(ns);
          addDeflocs(scope);
          scope.pop();
        });

      // add definition-location info for all ports.
      namespace.elements.filter (ast.is_p ('system'))
        .map(function (comp) {
          comp.ports.elements.map(function(port) {
            var intf = findComp (ast2go.type_name (port), scope)
            port.defloc = intf && intf.location;
          });
        });

      // add definition-location info for all ports.
      namespace.elements.filter (ast.is_p ('component'))
        .map(function (comp) {
          comp.ports.elements.map(function(port) {
            var intf = findComp (ast2go.type_name (port), scope)
            port.defloc = intf && intf.location;
          });
        });

      // add definition-location info for all instances.
      namespace.elements.filter (ast.is_p ('system'))
        .map(function (comp) {
          comp.instances.elements.map(function(instance) {
            var subcomp = findComp (ast2go.type_name (instance), scope);
            instance.defloc = subcomp && subcomp.location;
          });
        });
      // add definition-location info for all bindings.
      namespace.elements.filter (ast.is_p ('system'))
        .map(function (comp) {
          comp.bindings.elements.map(function(bnd) {
            console.log ('bnd=%j', bnd);
            var port = (bnd.left.port_name == '*') ? bnd.right : bnd.left;
            var portcomp;
            if (port.instance_name) {
              var instance = comp.instances.elements.find (ast.field_eq_p ('name', port.instance_name));
              portcomp = instance && findComp (ast2go.type_name (instance), scope);
            } else {
              portcomp = comp;
            }
            var the_p = portcomp
                && portcomp.ports.elements.find (ast.field_eq_p ('name', port.port_name));
            var intf = the_p && findComp (ast2go.type_name (the_p), scope);
            bnd.defloc = intf && intf.location;
          });
        });
    }

    function addPortNode(node, portId, label, dir, external, loc, defloc) {
      node.portArray.push({portId: portId, data: {label: label, dir: dir, external: external, fileloc: loc, defloc: defloc}});
    }

    function addCompNode(name, type, scope, group, loc, defloc) {
      var comp = findComp (type, scope);
      if (comp) {
        console.log ('comp = %j', comp);
        console.log ('klas = %j', ast.klass (comp));
        var node = {key: name, label: type, type: ast.klass (comp), isGroup: ast.is_a(comp,'system'), injected: false, fileloc: loc, defloc : defloc};
        if (group!=null) {
          node.group = group;
          node.isSubGraphExpanded = false;
        }
        else {
          node.group = '';
          node.isSubGraphExpanded = true;
        }
        node.size = ast2go.calcSize (root, comp);
        node.numSubs = comp.instances && comp.instances.elements && comp.instances.elements.length || 0;
        node.portArray = Array();

        comp.ports.elements
          .filter (ast.field_eq_p ('direction', 'provides'))
          .forEach(function(port) {
            var label = ast2go.type_name (port) + ' ' + port.name;
            addPortNode(node, port.name, label, 'in', false, port.location, port.defloc);
          });

        comp.ports.elements
          .filter (ast.field_eq_p ('direction', 'requires'))
          .forEach(function(port) {
            var label = ast2go.type_name (port) + ' ' + port.name;
            addPortNode(node, port.name, label, port.injected?'inj':'out', port.external, port.location, port.defloc);
          });

        comp.inherited_ports
          .forEach(function(inh) {
            var label = inh.type + ' ' + inh.name;
            addPortNode(node, inh.name, label, 'inj', false, null, null);
          });

        node.inPortTot = 0;
        node.outPortTot = 0;
        node.injPortTot = 0;
        node.portArray.forEach(function (port) {
          if (port.data.dir == 'in') node.inPortTot++;
          else if (port.data.dir == 'out') node.outPortTot++;
          else /* port.data.dir == 'inj' */ node.injPortTot++;
        });
        var inPortNr = 0;
        var outPortNr = 0;
        var injPortNr = 0;
        node.portArray.forEach(function (port) {
          if (port.data.dir == 'in') {
            port.data.relloc = (inPortNr+.5)/node.inPortTot;
            port.data.index = inPortNr;
            inPortNr++;
          }
          else if (port.data.dir == 'out') {
            port.data.relloc = (outPortNr+.5)/node.outPortTot;
            port.data.index = outPortNr;
            outPortNr++;
          }
          else { // port.data.dir == 'inj'
            port.data.relloc = (injPortNr+.5)/node.injPortTot;
            port.data.index = node.outPortTot + injPortNr;
            injPortNr++;
          }
        });

        model.nodeDataArray.push(node);
      }
    }

    function addLink(from, fromPort, to, toPort, loc, defloc) {
      model.linkDataArray.push({from: from, fromPort: fromPort, to: to, toPort: toPort, fileloc: loc, defloc: defloc});
    }

    model.nodeDataArray = Array();
    model.linkDataArray = Array();

    function addSubTree(name, type, scope, group, loc, defloc) {

      function addDerivedBinding(name, left_instance, left_port, comp, sub, porttype) {
        var right = getBoundInjectedPort(comp, sub, porttype);
        if (right) {
          addLink(name+'.'+left_instance, left_port, name+'.'+right.instance_name, right.port_name, null, null);
        } else {
          var inh = comp.inherited_ports.find(function(port) { return port.type == porttype; });
          if (inh) {
            addLink(name+'.'+left_instance, left_port, name, inh.name, null, null);
          }
        }
      }

      addCompNode(name, type, scope, group, loc, defloc);
      var comp = findComp (type, scope);
      if (comp && ast.is_a (comp, 'system')) {
        comp.instances.elements.forEach(function(instance) {
          addSubTree(name+'.'+ instance.name, ast2go.type_name (instance), comp.scope, name, instance.location, instance.defloc);

          var subcomp = findComp (ast2go.type_name (instance), scope);
          if (subcomp) {
            var requires = subcomp.ports.elements.filter (ast.field_eq_p ('direction', 'requires'));
            requires.forEach(function(req) {
              if (req.injected) {
                addDerivedBinding(name, instance.name, req.name, comp, subcomp, ast2go.type_name (req));
              }
            });
            subcomp.inherited_ports.forEach(function(inh) {
              addDerivedBinding(name, instance.name, inh.type, comp, subcomp, inh.type);
            });
          }
        });

        comp.bindings.elements.forEach(function(binding) {
          var comp0 = !binding.left.instance_name ? name : name + '.' + binding.left.instance_name;
          var comp1 = !binding.right.instance_name ? name : name + '.' + binding.right.instance_name;
          if (binding.left.port_name !='*' && binding.right.port_name !='*') {
            var dir = getPortDir(comp, binding.left.instance_name || type, binding.left.port_name);
            if (dir=='out') {
              addLink(comp0, binding.left.port_name, comp1, binding.right.port_name, binding.location, binding.defloc);
            }
            else {
              addLink(comp1, binding.right.port_name, comp0, binding.left.port_name, binding.location, binding.defloc);
            }
          }
        });

      }
    }

    function getBoundInjectedPort(comp, sub, type) {
      function checkBinding(left, right) {
        console.log('left: instance = ' + left.instance_name + '; port = ' + left.port_name);
        if ((left.port_name == '*' && (!left.instance_name || left.instance_name == sub.name))
            && (right.instance_name != sub.name)) {
          var inst = comp.instances.elements.find (ast.field_eq_p ('name', right.instance_name));
          var subcomp1 = inst && findComp (ast2go.type_name (inst), comp.scope);
          var port = subcomp1 && subcomp1.ports.elements.find (port_name_direction_p (right.port_name, 'provides'));
          if (port && ast2go.type_name (port) == type) {
            return right;
          }
        }
        return null;
      }
      var res;
      for (var i=0; i!=comp.bindings.elements.length; i++) {
        var binding = comp.bindings.elements[i];
        res = checkBinding(binding.left, binding.right)
          || checkBinding(binding.right, binding.left);
        if (res) return res;
      }
      return null;
    }

    function getInheritedPorts(o, scope) {
      scope = scope || [];
      if (ast.is_a(o, 'root') || ast.is_a(o, 'namespace')) {
        o.elements
          .filter (function (elt) {
            return ast.is_p ('namespace') (elt) ||
              ast.is_p ('component') (elt) ||
              ast.is_p ('foreign') (elt) ||
              ast.is_p ('system') (elt);
          })
          .forEach (function (elt) {
            scope.push(o);
            getInheritedPorts (elt, scope)
            scope.pop();
          });
      } else {
        var comp = o;
        if (!comp.inherited_ports) {
          comp.inherited_ports = [];
          if (comp.system) {
            comp.instances.elements.forEach(function(instance) {
              var subcomp = findComp (ast2go.type_name (instance), scope);
              if(subcomp) {
                var requires = subcomp.ports.elements.filter (ast.field_eq_p ('direction', 'requires'));
                if (!requires) console.log('==== ' + 'rootFile' + ' ===  ' + JSON.stringify(subcomp));
                requires.forEach(function(req) {
                  if (req.injected) {
                    if (!getBoundInjectedPort(comp, instance, ast2go.type_name(req))) {
                      if (!comp.inherited_ports.find(function(inh) { return inh.name == ast2go.type_name(req); })) {
                        comp.inherited_ports.push({type: ast2go.type_name(req), name: ast2go.type_name(req)});
                      }
                    }
                  }
                });
                getInheritedPorts(subcomp, scope).forEach(function(inh) {
                  if (!getBoundInjectedPort(comp, instance, inh.type)) {
                    if (!comp.inherited_ports.find(ast2go.field_eq_p('type_name', inh.type))) {
                      comp.inherited_ports.push({type: inh.type, name: inh.type});
                    }
                  }
                });
              }
            });
          }
        }
        return comp.inherited_ports;
      }
    }

    addDeflocs();
    getInheritedPorts(root);

    var comp = findComp (sut, [root]);
    console.log ('TOP comp[%s]: %j', sut, comp);
    if (comp) {
      addSubTree (sut, sut, [root], null, comp.location, comp.location);
    }

    return model;
  }
}

if (node_p ()) {
  module.exports = ast2go;
}
