var SeqDiag = {
    in: {
      gotoIndex: function(index) {
        var links = SeqDiag.model.linkDataArray;
        if (links.length == 0) return;
        var last = links[0];
        for (var i = 0; i != links.length; i++) {
          if (links[i]) {
            if (links[i].fromindex <= index) last = links[i];
            if (links[i].toindex <= index) last = links[i];
          }
        }
        SeqDiag.diagram.select(SeqDiag.diagram.findLinkForData(last));
        SeqDiag.setState(last.state);
      },

      draw: function (json) {
        SeqDiag.model = go.Model.fromJson (json);
        SeqDiag.model.addNodeData({category: 'background', key: '-background-'});
        SeqDiag.diagram.model = SeqDiag.model;
        SeqDiag.requestScrollDown = true;
        SeqDiag.selectLifeline(SeqDiag.getmainlifeline());

        var links = SeqDiag.model.linkDataArray;
        var last = null;
        for (var i = 0; i != links.length; i++) {
          if (links[i] && links[i].state)
            last = links[i];
        }
        if (last) SeqDiag.finalState = last.state;
        else {
          var initialState = [];
          SeqDiag.model.nodeDataArray.filter(function(n) {return n.category == 'header';})
            .forEach(function(n) { initialState[n.key.slice(1)] = n.state; });
          SeqDiag.finalState = initialState;
        }
      },
      init: {}
    },
  out: {
    setIndex: function() {},
    handleEligible: function() {}
  },

  // private
  diagram: null,
  requestScrollDown: false,
  lifelineId: null,
  headerId: null,
  selectedLifeline: null,
  model: null,
  finalState: null,
  scale: null,

  init: function(diagramID) {
    var $ = go.GraphObject.make;


    var redgrad = $(go.Brush, go.Brush.Linear, {start: go.Spot.Left, end: go.Spot.Right, 0: 'red', 0.5: '#FFCCCC', 1: 'red'});
    var greygrad = $(go.Brush, go.Brush.Linear, {start: go.Spot.Left, end: go.Spot.Right, 0: 'grey', 0.5: '#CCCCCC', 1: 'grey'});
    var radgrad = $(go.Brush, go.Brush.Radial, {0: 'rgb(255, 255, 255)', 0.7: 'rgb(255, 255, 255)', 1: 'rgba(255, 255, 255, 0)'});
    var fadein = $(go.Brush, go.Brush.Linear, {start: go.Spot.Right, end: go.Spot.Left, 0: 'white', 0.25: 'white', 0.5: 'black', 1: 'black'});
    var fadeout = $(go.Brush, go.Brush.Linear, {start: go.Spot.Bottom, end: go.Spot.Top, 0: 'rgba(255, 255, 255, 0)', .5: 'white' });

    //layouting:
    var HeaderHeight = 0;

    var LaneDistance = 160; // minimal distance between lanes;
    var LinePrefix = 10;  // vertical starting point in document for all Messages and Activations
    var LineSuffix = 10;  // vertical length beyond the last message time
    var MessageSpacing = 15;  // vertical distance between Messages at different steps
    var ButtonSpacing = 28; // vertical spacing between eligible buttons
    var ActivityWidth = 8;  // width of each vertical activity bar
    var ActivityStart = 0;  // height before start message time
    var ActivityEnd = 0;  // height beyond end message time

    SeqDiag.selectedLifeline = null;

    SeqDiag.diagram =
      $(go.Diagram, diagramID,
        {
          initialContentAlignment: go.Spot.Center,
          allowDelete: false,
          allowCopy: false,
          'resizingTool.isGridSnapEnabled': true,
          'draggingTool.gridSnapCellSize': new go.Size(1, MessageSpacing / 4),
          'draggingTool.isGridSnapEnabled': true
        }
       );

    var foreLayer = SeqDiag.diagram.findLayer('Foreground');
    SeqDiag.diagram.addLayerBefore($(go.Layer, { name: 'lifelineLayer' }), foreLayer);
    SeqDiag.diagram.addLayerBefore($(go.Layer, { name: 'headerBackgroundLayer' }), foreLayer);
    SeqDiag.diagram.addLayerBefore($(go.Layer, { name: 'headerLayer' }), foreLayer);

    var lifelineGroupTemplate =
      $(go.Group, 'Vertical',
        {
          layerName: 'lifelineLayer',
          locationSpot: go.Spot.Top,
          minLocation: new go.Point(-Infinity, NaN),  // only allow horizontal movement
          maxLocation: new go.Point(Infinity, NaN),
          selectable: true,
          selectionAdorned: false
        },
        new go.Binding('location', 'loc', function(loc, node) {
          var location = go.Point.parse(loc);
          node.location = location;
          return location;
        }).makeTwoWay(go.Point.stringify),
        $(go.Shape,
          {
            name: 'LINE',
            figure: 'LineV',
            fill: null,
            stroke: 'gray',
            strokeDashArray: [3, 3],
            alignment: go.Spot.Top,
            portId: '',
            fromLinkable: true,
            fromLinkableDuplicates: true,
            toLinkable: true,
            toLinkableDuplicates: true,
            cursor: 'pointer'
          },
          new go.Binding('strokeWidth', 'selected', function(selected) { return selected ? 3 : 1; }),
          new go.Binding('height', 'duration', computeLifelineHeight)
         )
       );

    var activityNodeTemplate =
      $(go.Node, 'Spot',
        {
          layerName: 'lifelineLayer',
          locationSpot: go.Spot.Top,
          selectable: false,
          locationObjectName: 'SHAPE'
        },
        new go.Binding('location', '', computeActivityLocation),
        $(go.Shape, 'Rectangle',
          {
            name: 'SHAPE',
            fill: redgrad, stroke: 'black',
            width: ActivityWidth
          },
          new go.Binding('height', 'duration', computeActivityHeight),
          new go.Binding('fill', 'thread', function(s) {
            return (s == 'active' ? redgrad : greygrad);
          })
         )
       );

    var eligibleNodeTemplate =
      $(go.Node, 'Spot',
        {
          layerName: 'lifelineLayer',
          locationSpot: go.Spot.Top,
          locationObjectName: 'BUTTON',
          selectable: false,
          isShadowed: false
        },
        new go.Binding('location', '', computeEligibleLocation),
        $(go.Panel, 'Auto',
          {
            name: 'BUTTON'
          },
          $('Button',
            {
              name: 'eligibleButton',
              click: function(e, obj) {
                disableEligibleButtons();
                SeqDiag.out.handleEligible(obj.key);
              }
            },
            new go.Binding('ButtonBorder.fill', 'key', button_key2color),
            new go.Binding('key', 'key'),
            $(go.Shape,
              { fill: null, stroke: null,
                desiredSize: new go.Size(1, 1)
              }
             ),
            $(go.TextBlock,
              {margin: new go.Margin(1,3,1,3)},
              new go.Binding('text', 'name')
             )
           )
         )
       );

    var backgroundNodeTemplate =
        $(go.Node, 'Spot',
          {
            layerName: 'headerBackgroundLayer',
            minLocation: new go.Point(-Infinity, NaN),  // only allow horizontal movement
            maxLocation: new go.Point(Infinity, NaN),
            selectable: true,
            selectionAdorned: false,
            locationObjectName: 'HEADER',
            selectionObjectName: 'HEADER',
            locationSpot: go.Spot.Top,
            isShadowed: false
          },
          new go.Binding('location', 'loc', function(loc, node) {
            var location = go.Point.parse(loc);
            return location;
          }).makeTwoWay(go.Point.stringify),
          $(go.Panel, 'Position',
            { name: 'RECTHEADER',
            },
            $(go.Shape, 'Rectangle',
              {
                name: 'RECT',
                fill: fadeout,
                stroke: 'transparent'
              },
              new go.Binding('width', 'width').makeTwoWay(),
              new go.Binding('height', 'height').makeTwoWay(),
             )
           )
         );

    var headerNodeTemplate =
      $(go.Node, 'Spot',
        {
          layerName: 'headerLayer',
          minLocation: new go.Point(-Infinity, NaN),  // only allow horizontal movement
          maxLocation: new go.Point(Infinity, NaN),
          selectable: true,
          selectionAdorned: false,
          locationSpot: go.Spot.Top,
          isShadowed: true,
          shadowColor: '#CCCCCC',
          shadowOffset: new go.Point(2,2)
        },
        new go.Binding('shadowOffset', 'selected', function (selected) {
          return selected ? new go.Point(3,3) : new go.Point(2,2);
        }),
        new go.Binding('location', 'loc', function(loc, node) {
          var location = go.Point.parse(loc);
          var lkey = node.key.slice(1);
          var lifeline = SeqDiag.diagram.findNodeForKey(lkey);
          if (lifeline) {
            SeqDiag.diagram.startTransaction('header location');
            lifeline.moveTo(location.x, lifeline.location.y, true);
            SeqDiag.diagram.commitTransaction('header location');
          }
          return location;
        }).makeTwoWay(go.Point.stringify),
        $(go.Panel, 'Auto',
          {
            alignmentFocus: go.Spot.Top,
            alignment: go.Spot.Center,
            name: 'HEADER'
          },
          new go.Binding('key', 'key'),
          $(go.Shape, 'RoundedRectangle',
            {
              name: 'RECT',
              fill: 'lightgreen',
              stroke: 'grey',
              strokeWidth: 1,
            },
            new go.Binding('fill', 'role', role2color)
           ),
          $(go.Panel, 'Vertical',
            {
              alignmentFocus: go.Spot.Top,
              alignment: go.Spot.Center
            },
            $(go.TextBlock,
              {margin: new go.Margin(5,5,2,5),
               font: 'bold 13px sans-serif'
              },
              new go.Binding('text', 'text')
             ),
            $(go.Shape, 'BarH',
              {
                fill: 'grey',
                height: .5,
                strokeWidth: 0,
              },
             ),
            $(go.TextBlock,
              {margin: new go.Margin(2,5,5,5),
               font: '12px sans-serif'
              },
              new go.Binding('text', 'state', layoutState)
             )
           )
         )
       );


    button_key2color
    function button_key2color(key) {
      if (key == '--back--') return '#E3F0F5';
      else return '#C8F0FF';
    }

    function role2color(role) {
      if (/provided/i.test(role)) return '#FFFCB0';
      if (/required/i.test(role)) return '#FFFCB0';
      if (role == "component") return '#AEE8A0';
      if (role == "interface") return '#AEE8A0';
    }

    function layoutState(state) {
      return state
        .map(function(s) {
          return s.variable + ':' + s.value;
        }).join('\n');
    };


    // a custom routed Link
    function MessageLink() {
      go.Link.call(this);
      this.time = 0;  // use this 'time' value when this is the temporaryLink
    }
    go.Diagram.inherit(MessageLink, go.Link);


    function getTextWidth(text, font, canvas) {
      // if given, use cached canvas for better performance
      // else, create new canvas
      canvas = canvas || document.createElement('canvas');
      var context = canvas.getContext('2d');
      context.font = font;
      var metrics = context.measureText(text);
      return metrics.width;
    };

    function computeLifelineHeight(duration) {
      return LinePrefix + duration * MessageSpacing + LineSuffix + ActivityStart;
    }

    function computeEligibleLocation(eligible) {
      var groupdata = SeqDiag.model.findNodeDataForKey(eligible.group);
      if (groupdata == null)
        return new go.Point();
      // get location of Lifeline's starting point
      var grouploc = go.Point.parse(groupdata.loc);
      //var groupheight = computeLifelineHeight(groupdata.duration);
      var y = convertTimeToY(groupdata.duration) + (eligible.time)*ButtonSpacing + grouploc.y;
      // compensate for possible verification error message:
      var modellinks = SeqDiag.model.linkDataArray;
      var last = (modellinks.length > 0) && modellinks[modellinks.length-1];
      if (last && last.error) {
        y += 15;
      }
      return new go.Point(grouploc.x, y);
    }

    function computeActivityLocation(act) {
      var groupdata = SeqDiag.model.findNodeDataForKey(act.group);
      if (groupdata == null)
        return new go.Point();
      // get location of Lifeline's starting point
      var grouploc = go.Point.parse(groupdata.loc);
      var y = convertTimeToY(act.start) - ActivityStart;
      return new go.Point(grouploc.x, y);
    }

    function computeActivityHeight(duration) {
      return ActivityStart + duration * MessageSpacing + ActivityEnd;
    }

    // time is just an abstract small non-negative integer
    // here we map between an abstract time and a vertical position
    function convertTimeToY(t) {
      return t * MessageSpacing + LinePrefix;
    }
    function convertYToTime(y) {
      return (y - LinePrefix) / MessageSpacing;
    }

    function disableEligibleButtons() {
      for (var it = SeqDiag.diagram.nodes; it.next(); ) {
        var node = it.value;
        if (node.category == 'eligible') {
          node.findObject('eligibleButton').isEnabled = false;
        }
      }
    }

    MessageLink.prototype.getLinkPoint = function(node, port, spot, from, ortho, othernode, otherport) {
      var p = port.getDocumentPoint(go.Spot.Center);
      var r = new go.Rect(port.getDocumentPoint(go.Spot.TopLeft),
                          port.getDocumentPoint(go.Spot.BottomRight));
      var op = otherport.getDocumentPoint(go.Spot.Center);

      var data = this.data;
      var time = data != null ? data.time : this.time;  // if not bound, assume this has its own 'time' property

      var aw = this.findActivityWidth(node, time);
      var x = (op.x > p.x ? p.x + aw / 2 : p.x - aw / 2);
      var y = convertTimeToY(time);
      return new go.Point(x, y);
    };

    MessageLink.prototype.getLinkDirection = function(node, port, linkpoint, spot, from, ortho, othernode, otherport) {
      var p = port.getDocumentPoint(go.Spot.Center);
      var op = otherport.getDocumentPoint(go.Spot.Center);
      var right = op.x > p.x;
      return right ? 0 : 180;
    };

    MessageLink.prototype.findActivityWidth = function(node, time) {
      var aw = ActivityWidth;
      if (node instanceof go.Group) {
        // see if there is an Activity Node at this point -- if not, connect the link directly with the Group's lifeline
        var found = false;
        var mit = node.memberParts;
        while (mit.next()) {
          var act = mit.value.data;
          if (act != null && act.start <= time && time <= act.start + act.duration) {
            found = true;
            break;
          }
        }
        if (!found) {
          aw = 0;
        }
      }
      return aw;
    };

    MessageLink.prototype.computePoints = function() {
      if (this.fromNode && this.fromNode === this.toNode) {  // also handle a reflexive link as a simple orthogonal loop
        var data = this.data;
        var time = data !== null ? data.time : this.time;  // if not bound, assume this has its own 'time' property
        var p = this.fromNode.port.getDocumentPoint(go.Spot.Center);
        var aw = this.findActivityWidth(this.fromNode, time);

        var x = p.x + aw / 2;
        var y = convertTimeToY(time);
        this.clearPoints();
        this.addPoint(new go.Point(x, y));
        this.addPoint(new go.Point(x + 50, y));
        this.addPoint(new go.Point(x + 50, y + 5));
        this.addPoint(new go.Point(x, y + 5));
        return true;
      } else {
        return go.Link.prototype.computePoints.call(this);
      }
    };

    // end MessageLink

    var lifelineLinkTemplate =
      $(MessageLink,
        {
          layerName: 'lifelineLayer',
          selectionAdorned: true,
          curviness: 0,
        },
        $(go.Shape, 'Rectangle',
          {
            name: 'SHAPE',
            stroke: 'black',
            isPanelMain: true
          },
          new go.Binding('stroke', 'missing', function(missing) {
            return (missing? fadein: 'black');
          }),
          new go.Binding('visible', 'kind', function(t) {
            return (t!='error');
          }),
          new go.Binding('strokeDashArray', 'kind', function(t) {
            return (t == 'return' ? [3, 3] : [1, 0]);
          })
         ),
        $(go.Shape,
          {
            toArrow: 'Triangle',
            stroke: 'black'
          },
          new go.Binding('visible', 'kind', function(t) {
            return (t!='error');
          }),
          new go.Binding('toArrow', 'kind', function(t) {
            return (t == 'call' ? 'Triangle' : 'OpenTriangle');
          })
         ),
        $(go.Panel, 'Auto',
          {
            alignmentFocus: go.Spot.Bottom
          },
          $(go.Shape,
            {
              fill: radgrad,
              stroke: null
            }
           ),
          $(go.TextBlock,
            {
              isMultiline: true,
              editable: false,
              margin: 1
            },
            new go.Binding('text', 'text')
           )
         ),
        $(go.Panel, 'Vertical',
          {
            alignmentFocus: go.Spot.Top,
            alignment: go.Spot.Center
          },
          $(go.Picture,
            {
              source: 'data:image/png;base64,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',
              margin: 2,
              visible: false
            },
            new go.Binding('visible', 'error', function(error)
                           {return error!=''}
                          )
           ),
          $(go.TextBlock,
            {
              isMultiline: true,
              editable: false,
              width: 200,
              wrap: go.TextBlock.WrapFit,
              textAlign: 'center',
              margin: 1
            },
            new go.Binding('text', 'error')
           )
         )
       );

    SeqDiag.diagram.groupTemplateMap.add('lifeline', lifelineGroupTemplate);
    SeqDiag.diagram.nodeTemplateMap.add('activity', activityNodeTemplate);
    SeqDiag.diagram.nodeTemplateMap.add('eligible', eligibleNodeTemplate);
    SeqDiag.diagram.nodeTemplateMap.add('background', backgroundNodeTemplate);
    SeqDiag.diagram.nodeTemplateMap.add('header', headerNodeTemplate);
    SeqDiag.diagram.linkTemplate = lifelineLinkTemplate;

    function onInitialLayoutCompleted() {
      if (! SeqDiag.model) return;

      var header_data = SeqDiag.model.nodeDataArray.filter(function(n) {return n.category == 'header';});
      var header_nodes = Array(header_data.length);
      for (var it = SeqDiag.diagram.nodes; it.next(); ) {
        var hnode = it.value;
        if (hnode.category == 'header') {
          header_nodes[hnode.data.lane_nr] = {node: hnode, x: 0};
        }
      }

      // spread the lanes, with a minimum distance of LaneDistance; take care the headers do not overlap.
      var spread = LaneDistance;

      SeqDiag.model.startTransaction('set header');
      //center the lanes in the diagram (approximation)
      header_nodes[0].x = -(header_nodes.length-1)/2*spread;
      SeqDiag.model.set(header_nodes[0].node.data, 'loc', '' + header_nodes[0].x + ' 0');
      for (var l = 1; l < header_nodes.length; l++) {

        var w0 = header_nodes[l-1].node.measuredBounds.width;
        var w1 = header_nodes[l].node.measuredBounds.width;
        var dist = Math.max((w0/2 + w1/2 + 10), spread);
        header_nodes[l].x = header_nodes[l-1].x + dist;
        SeqDiag.model.set(header_nodes[l].node.data, 'loc', '' + header_nodes[l].x + ' 0');
      }
      SeqDiag.model.commitTransaction('set header');

      // reserve extra space for the lanes:
      var max_height = 0;
      for (var l = 0; l < header_nodes.length; l++) {
        var h = header_nodes[l].node.measuredBounds.height;
        max_height = Math.max(max_height, h);
      }
      LinePrefix = 20 + max_height;
      // force re-layout // FIXME: find gojs hook i.s.o. model.set

      SeqDiag.model.startTransaction('height changed');
      SeqDiag.model.nodeDataArray.forEach(function(n) {
        if (n.category == 'lifeline') {
          SeqDiag.model.set(n, 'duration', n.duration);
          // new go.Binding('height', 'duration', computeLifelineHeight)
        } else if (n.category == 'activity') {
          SeqDiag.model.set(n, 'loc', null);
           //new go.Binding('location', '', computeActivityLocation),
        } else if (n.category == 'eligible') {
          SeqDiag.model.set(n, 'loc', null);
          // new go.Binding('location', '', computeEligibleLocation),
        }
      });
      SeqDiag.model.commitTransaction('height changed');

      // keep previous scale:
      if (SeqDiag.scale) SeqDiag.diagram.scale = SeqDiag.scale;
    };

    function onLayoutCompleted() {
      for (var it = SeqDiag.diagram.nodes; it.next(); ) {
        var node = it.value;
        if (node.category == 'background') {
          setBackgroundPosition(node);
        }
      }
      checkScrollDown();
    };

    function changedListener(e) {
      if (SeqDiag.scale) SeqDiag.scale = SeqDiag.diagram.scale;
    };

    function checkScrollDown() {
      if (SeqDiag.requestScrollDown) {
        SeqDiag.requestScrollDown = false;
        SeqDiag.diagram.scroll('document', 'down');
      }
    };

    function onChangedSelection() {
      // change header state
      var messageSelected = false;
      if (SeqDiag.diagram.selection.count>0) {
        var selection = SeqDiag.diagram.selection.first();
        if ('selectionObjectName' in selection) {
          var obj = selection.findObject(selection.selectionObjectName);
          messageSelected = obj && obj.data && SeqDiag.hasindex(obj.data);
        }
      }
      if (!messageSelected)
        SeqDiag.setState(SeqDiag.finalState);

      if (SeqDiag.diagram.selection.count>0) {
        // scroll..
        var bound = selection.actualBounds;
        if ('selectionObjectName' in selection) {
          var obj = selection.findObject(selection.selectionObjectName);
          if (obj != null) {
            bound = obj.actualBounds;
          }
        }
        var rect  = new go.Rect(SeqDiag.diagram.viewportBounds.x, bound.y, SeqDiag.diagram.viewportBounds.width, bound.height)
        SeqDiag.diagram.scrollToRect(rect);
      }
    };

    function viewportChanged() {
      var xxx = SeqDiag.diagram.documentBounds;
      var bounds = SeqDiag.diagram.viewportBounds;
      for (var it = SeqDiag.diagram.nodes; it.next(); ) {
        var node = it.value;
        if (node.category == 'header') {
          SeqDiag.model.startTransaction('header changed');
          SeqDiag.model.set(node.data, 'loc', '' + node.location.x + ' ' + bounds.top);
          SeqDiag.model.commitTransaction('header changed');
        }
        if (node.category == 'background') {
          setBackgroundPosition(node);
        }
      }
    };

    function setBackgroundPosition(node) {
      var x_min = 99999;
      var x_max = -99999;
      var height = 0;
      for (var it = SeqDiag.diagram.nodes; it.next(); ) {
        var hnode = it.value;
        if (hnode.category == 'header') {
          var x = hnode.location.x;
          var w = hnode.measuredBounds.width;
          x_min = Math.min(x_min, x - w/2);
          x_max = Math.max(x_max, x + w/2);
          height = Math.max(height, hnode.measuredBounds.height);
        }
      }

      var bounds = SeqDiag.diagram.viewportBounds;
      SeqDiag.model.startTransaction('top changed');
      SeqDiag.model.set(node.data, 'width', x_max-x_min);
      SeqDiag.model.set(node.data, 'height', height+10);
      var location = node.location;
      SeqDiag.model.set(node.data, 'loc', '' + (x_min+x_max)/2 + ' ' + (bounds.top));
      SeqDiag.model.commitTransaction('top changed');
    };

    function positionComputation(diagram, pt) {
      return new go.Point(pt.x, Math.max(pt.y, 0));
    };

    function standardMouseSelect() {
      var e = SeqDiag.diagram.lastInput;
      var obj = SeqDiag.diagram.findPartAt(e.documentPoint);
      if (obj && obj.data) {
        var data = obj.data;
        if (SeqDiag.hasindex(data)) {
          var index = SeqDiag.lifelineIndex(data, SeqDiag.selectedLifeline);
          console.log('trace click index: %s: event: %j', index, e);
          SeqDiag.out.setIndex(SeqDiag.lifelineIndex(data, SeqDiag.selectedLifeline));
        } else if (SeqDiag.islifeline(data)) {
          SeqDiag.selectLifeline(SeqDiag.getlifeline(data));
        } else if (SeqDiag.isheader(data)) {
          var selection = SeqDiag.diagram.selection.copy();
          selection.each(function(part) { part.isSelected = false; });
          obj.isSelected = true;
          SeqDiag.selectedHeader = data;
        }
      }
      var tool = SeqDiag.diagram.toolManager.clickSelectingTool;
      go.ClickSelectingTool.prototype.standardMouseSelect.call(tool);
    };

    function doKeyDown() {
      var e = SeqDiag.diagram.lastInput;
      switch (e.key)
      {
        case 'Up': {
          selectNext(-1);
          break;
        }
        case 'Down': {
          selectNext(1);
          break;
        }
        case 'Left': {
          break;
        }
        case 'Right': {
          break;
        }
        default: {
          go.CommandHandler.prototype.doKeyDown.call(this);
          break;
        }
      }
    };

    function selectNext(dir) {
      var selectedPart = SeqDiag.diagram.selection.first();
      var nextPart = null;
      var foundSelected = false;
      var itr = SeqDiag.diagram.links;
      var prev = null;
      while (itr.next()) {
        if ((itr.value)==selectedPart) {
          foundSelected = true;
          if (dir==-1) {
            nextPart = prev;
            break;
          }
        }
        else if (foundSelected) {
          if (SeqDiag.hasLifelineIndex(itr.value, SeqDiag.selectedLifeline)) {
            nextPart = itr.value;
            break;
          }
        }
        if (SeqDiag.hasLifelineIndex(itr.value, SeqDiag.selectedLifeline)) prev = itr.value;
      }
      if (nextPart !== null) {
        SeqDiag.diagram.select(nextPart);
        SeqDiag.out.setIndex(SeqDiag.lifelineIndex(nextPart.data, SeqDiag.selectedLifeline));
      }
    };

    // automatically extend Lifelines as Activities are moved or resized
    SeqDiag.diagram.addDiagramListener('LayoutCompleted', onLayoutCompleted);
    SeqDiag.diagram.addDiagramListener("InitialLayoutCompleted", onInitialLayoutCompleted);
    SeqDiag.diagram.addChangedListener(changedListener);

    SeqDiag.diagram.maxSelectionCount = 1;
    SeqDiag.diagram.addDiagramListener('ChangedSelection', onChangedSelection);
    SeqDiag.diagram.addDiagramListener('ViewportBoundsChanged', viewportChanged);
    SeqDiag.diagram.positionComputation = positionComputation;
    SeqDiag.diagram.toolManager.clickSelectingTool.standardMouseSelect = function () { standardMouseSelect(); };
    SeqDiag.diagram.toolManager.dragSelectingTool.isEnabled = false;
    SeqDiag.diagram.toolManager.panningTool.isEnabled = false;
    SeqDiag.diagram.toolManager.resizingTool.isEnabled = false;
    SeqDiag.diagram.toolManager.linkingTool.isEnabled = false;
    SeqDiag.diagram.commandHandler.doKeyDown = doKeyDown;
    SeqDiag.diagram.model.undoManager.isEnabled = true;
    SeqDiag.diagram.animationManager.isEnabled = false;

//    SeqDiag.diagram.scrollMode = go.Diagram.InfiniteScroll;
    SeqDiag.diagram.padding = new go.Margin(5, 10, 5, 5);

    var css = 'canvas {  outline: none; -webkit-tap-highlight-color: rgba(255, 255, 255, 0); }',
        head = document.head || document.getElementsByTagName('head')[0],
        style = document.createElement('style');
    style.type = 'text/css';
    if (style.styleSheet){
      style.styleSheet.cssText = css;
    } else {
      style.appendChild(document.createTextNode(css));
    }
    head.appendChild(style);
  },

  setState: function(state) {
    for (var it = SeqDiag.diagram.nodes; it.next(); ) {
      var hnode = it.value;
      if (hnode.category == 'header') {
        SeqDiag.model.startTransaction('set state');
        var instance = hnode.key.slice(1); // drop 'H'
        SeqDiag.model.set(hnode.data, 'state', state[instance] || []);
        SeqDiag.model.commitTransaction('set state');
      }
    }
  },

  role: function(node) {
    var nodes = SeqDiag.model.nodeDataArray;
    var inst = nodes.filter(function(o) {return o.key == node;})[0];
    if (inst) return inst.role;
    return '';
  },

  isheader: function(node) {
    return node && (node.category == 'header') ;
  },

  islifeline: function(node) {
    if (!node) return false;
    var inst = null;
    if (node.isGroup)
      inst = SeqDiag.model.nodeDataArray.filter(function(o) {return o.key == node.key;})[0];
    else if (node.group)
      inst = SeqDiag.model.nodeDataArray.filter(function(o) {return o.group == node.group;})[0];
    return (inst != null);
  },

  getmainlifeline: function() {
    var inst = SeqDiag.model.nodeDataArray.filter(function(o) {
      return o.category == 'lifeline' && (o.role == 'component' || o.role == 'interface');
    })[0];
    return SeqDiag.getlifeline(inst);
  },

  getlifeline: function(node) {
    if (!node) return null;
    var key = null;
    var inst = null;
    if (node.isGroup) {
      inst = SeqDiag.model.nodeDataArray.filter(function(o) {return o.key == node.key;})[0];
      key = inst.key;
    }
    else if (node.group) {
      inst = SeqDiag.model.nodeDataArray.filter(function(o) {return o.group == node.group;})[0];
      key = inst.group;
    }
    if (key == null) return null;
    for (var it = SeqDiag.diagram.nodes; it.next(); ) {
      var node = it.value;
      if (node.data.key == key) return node;
    }
    return null;
  },

  hasindex: function(node) {
    if (!node || !node.to) return false;
    var to = SeqDiag.model.nodeDataArray.filter(function(o) {return o.key == node.to;})[0];
    if (!to) return false;
    return true;
  },

  hasLifelineIndex: function(node, lifeline) {
    if (lifeline)
      return (node &&
              node.data &&
              node.data.from &&
              (node.data.from == lifeline.data.key || node.data.to == lifeline.data.key));
    else
      return (node &&
              node.data &&
              node.data.from);
  },

  mainindex: function(nodedata) {
    if (nodedata) {
      // take care: when nodedata.from == nodedata.to, prefer nodedata.to,
      // since it most likely has position info
      var torole = SeqDiag.role(nodedata.to);
      if (torole == 'component' || torole == 'interface')
        return nodedata.toindex;
      else
        return nodedata.fromindex;
    }
  },

  lifelineIndex: function(nodedata, lifeline) {
    if (nodedata) {
      if (lifeline) {
        // take care: when nodedata.from == nodedata.to, prefer nodedata.to,
        // since it most likely has position info
        if (nodedata.to == lifeline.data.key)
          return nodedata.toindex;
        else if (nodedata.from == lifeline.data.key)
          return nodedata.fromindex;
        else
          return SeqDiag.mainindex(nodedata);
      }
      else
        return SeqDiag.mainindex(nodedata);
    }
  },

  selectLifeline: function(lifeline) {
    if (!lifeline) return;
    if (SeqDiag.selectedLifeline) {
      SeqDiag.model.setDataProperty(SeqDiag.selectedLifeline.data, 'selected', false);
    }
    SeqDiag.selectedLifeline = lifeline;
    SeqDiag.model.setDataProperty(SeqDiag.selectedLifeline.data, 'selected', true);
  },

};
