if (!Array.prototype.each) {
  Array.prototype.each = Array.prototype.forEach;
}

function line2states(state) {
  var s = sexp.read_from_string (state);
  var list = sexp.sexp_to_list (s);
  var state_alist = {};
  list.each (function (s) {
    state_alist[sexp.sexp_to_string (s.car)] =
      { model: s.cdr.car.car, kind: s.cdr.cdr.car.car, state: sexp.sexp_to_alist (s.cdr.cdr.cdr) };
  });
  return state_alist;
}

function average_index(node, nodes) {
  var subs = nodes.filter(function(n) {return n.group == node.key; });
  if (subs.length==0) return 1.0*node.index;
  var tot = 0;
  subs.forEach(function (sub) {
    tot += average_index(sub, nodes);
  });
  return tot / subs.length;
}

function initial_time(nodes) {
  return depth(nodes)*4;
}

function states2nodes(state_alist) {
  var nodes = Object.keys (state_alist).map (function (m) {
//    console.error("alist[%j] = %j", m, state_alist[m]);
    return {key:m, kind:state_alist[m].kind, model:state_alist[m].model};
  });
//  console.error('nodes-0=%j',nodes);
  nodes.forEach (function (node) {
    var m = node.key;
    var group = m.replace(/^(([^.]+[.])*)[^.]+$/, '$1');
    node.group = group.replace(/^(.*)[.]$/, '$1');
    node.sub = [];
  });
//  console.error('nodes-1=%j',nodes);

  nodes.forEach (function (node) {
    nodes.forEach (function (sub) {
      if (sub.group == node.key)
        node.sub.push(sub);
    });
  });
//  console.error('nodes-2=%j',nodes);

  nodes = nodes.map (function (node) {
    var m = node.key;
    var text = m.replace(/.*[.]([^.]+)/, '$1');
//    var text = m; // TODO: namespaces
    var model=node.model;
    var kind = node.kind;
    var category;
    if (node.sub.length > 0) {
      category = 'system';
    } else {
      category = 'component';
    }
    var group = node.group || '-top-';
    console.log('--- node %s: group %s', text, group);
    return {category:category, text:text, model:model, key:m, isGroup:true, group:group,
            kind:node.kind, hidden:category=='system'};
  });
//  console.error('nodes-3=%j',nodes);

  return nodes;
}

function line2link(s, timeoffset, index) { //todo: rename s to line
  //        console.error('------------------ s = %j', s);
  //        s = s.replace('.<q>.','.');
  //        console.error('              ---- s = %j', s);
  var m = s.match ('^([^ :]+):([-0-9]+)(?::[ \t]*([-0-9]+))?:(.*)');
  var file = m && m[1];
  var line = m && parseInt (m[2]);
  var column = m && parseInt (m[3]);
  s = m && m[4] || s;
  var selection = [{index:index,file:file,line:line,column:column}];
  var from_event = s.replace(/^[ \t]*(.*) (->|<-) (.*)$/, '$1');
  var to_event = s.replace(/^[ \t]*(.*) (->|<-) (.*)$/, '$3');
  var dir = s.replace (/.*(->|<-).*/, '$1');
  //        console.error('s=%j, from_event=%j, to_event=%j, dir=%j', s, from_event, to_event, dir);
  var from = from_event.replace(/<external>([.](.*[.])?)([^.]+)[.]([^.]+)/, '$2$3.$3.$4');
  from = from.replace(/(.*)[.][^.]+[.][^.]+/, '$1');
  var to = to_event.replace(/<external>([.](.*[.])?)([^.]+)[.]([^.]+)/, '$2$3.$3.$4');
  //        console.error('  to=%j', to);
  to = to.replace(/(.*)[.][^.]+[.][^.]+/, '$1');
  //        console.error('s=%j, from=%j, to=%j, dir=%j', s, from, to, dir);

  var text = from_event.replace(/.*[.]([^.]+)/, '$1'); //event
  from_event = from_event.split('.');
  var fromtext = from_event[0] == '<external>' ? from_event.slice(1,from_event.length - 1).join('.') :
      from_event[from_event.length - 2];
  to_event = to_event.split('.');
  var totext = to_event[0] == '<external>' ? to_event.slice(1,to_event.length - 1).join('.') :
      to_event[to_event.length - 2];

  // console.error ('dir=%j', dir);
  if (dir === '<-') {
    //console.error ('swap');
    var tmp;
    tmp = from; from = to; to = tmp;
    tmp = fromtext; fromtext = totext; totext = tmp;
  }
  var kind = (text == 'return') ? 'return' : 'call';
  return {category:'link', index:index, kind:kind,
          from:from, fromtext:fromtext, to:to, totext:totext, text:text,
          time:timeoffset+index, selection:selection};
}

function used_nodes(nodes, links) {
  function is_used(node) {
    var using = links.filter(function (link) {
      return node.key == link.from || node.key == link.to;
    });
    return using.length>0;
  };
  function has_used(node) {
    var sub = nodes.filter(function(n) {
      return (n.group+'.').search(node.key+'[.]') == 0;
    });
    var used = used_nodes(sub, links);
    return used.length>0;
  };

  return nodes.filter(function (node) {
    if (node.category == 'system') {
      return has_used(node);
    } else {
      return is_used(node);
    }
  });
}

function depth(nodes) {
  var depth = 0;
  nodes.forEach(function (node) {
    var d = (node.key.match(/[.]/g) || []).length;
    if (d > depth) depth = d;
  });
  return depth;
}

function add_location(nodes, links) {
  var xsep = 120;
  var ysep = 40;
  var yoffset = 70;
  var index = 0;
  nodes.forEach (function (node) {
    var subs = nodes.filter(function(n) {return n.group == node.key; });
    if (subs.length == 0) {
      index++;
      node.index = index;
    } else {
      node.index = 0;
    }
  });
  var d = depth(nodes);
  var duration = initial_time(nodes) + links.length;
//  console.error('depth = %j; initial_time = %j;#links = %j', d, initial_time(nodes), links.length);
  nodes.forEach(function (node) {
    node.loc = '' + (average_index(node, nodes) * xsep) + ' ' + (yoffset + (d * ysep));
    node.duration = duration;
  });

}

if (!Array.prototype.append_map) {
  Array.prototype.append_map = function(lambda) {
    return [].concat.apply([], this.map(lambda));
  }
}

var trail2go = {
  kind: function (nodes, nodeid) {
    return nodes.find(function (node) {return node.key == nodeid;}).kind;
  },
  events: function(trace, block) { //TODO instance
    return block.links
      .filter (function (link){
        return trail2go.kind(trace.nodeDataArray, link.from) == 'provides' ||
          trail2go.kind(trace.nodeDataArray, link.to) == 'provides' ||
          trail2go.kind(trace.nodeDataArray, link.from) == 'requires' ||
          trail2go.kind(trace.nodeDataArray, link.to) == 'requires';})
      .map (function (link){
        return (trail2go.kind(trace.nodeDataArray, link.from) == 'provides' ||
                trail2go.kind(trace.nodeDataArray, link.from) == 'requires') ?
          link.fromtext + '.' + link.text : link.totext + '.' + link.text;});
  },
  internal_events: function(trace, block) {
    return block.links
      .map (function (link){
        return {action:{port:link.fromtext,event:link.text}, trigger:{port:link.totext, event:link.text}};
      });
  }
  ,
  linkindex2blockindex: function(trace,index) {
    return trace.blocks.findIndex(function(block) {
      return block.links.length > 0
        && block.links[0].index <= index
        && index <= block.links[block.links.length-1].index;
    });
  },
  trail2go: function (trail) {
    console.error ('trail=%j', trail);
    var lines = trail.split ('\n')
        .filter (function (s) {return !s.match (/.*trail\[/) && !s.match (/\(eligible .*/);});
    var alist = line2states(lines[0]);
    var nodes = states2nodes(alist, lines.length);
    //    console.error('NODES='+JSON.stringify(nodes,null,2))
    var timeoffset = initial_time(nodes);
    var blocks = [];
    lines.forEach(function(line, index) {
      if(line[0] == '(') blocks.push({state:line2states(line), links:[]});
      else blocks[blocks.length - 1].links.push(line2link(line, timeoffset, index));
    });
    var links = blocks.append_map(function(block) {return block.links;});
    //console.error('LINKS='+JSON.stringify(links,null,2))
    //nodes=used_nodes(nodes,links);
    add_location(nodes, links);

    var min = 10000;
    nodes.forEach(function(n) {
      min = Math.min(min, n.loc.split(' ')[0]);
    });
    var top = {category:'top', key:'-top-', isGroup:true, loc: ''+min+' 0'};
    nodes.push(top);

    blocks.forEach(function(block,index) {
      var duration = block.links.length;
      if (duration) {
        var location = '0 0';
        var time = block.links[0].time;
        var index = block.links.length ? block.links[0].index : 0;
        var blocknode = {key: 'block'+index, group: '-top-', category:'block', duration: duration, loc: location, time: time, index: index};
        nodes.push(blocknode);
        block.blocknode = blocknode;
      }
    });


    return {blocks:blocks,nodeDataArray:nodes,linkDataArray:links};
  }
}

if (typeof module !== 'undefined') {
  module.exports = trail2go;
}
