var WW = {

  JsonSteps: [],
  StepData: [],
  currentStep: 0,
  currentIndex: 0,
  MinStep: 0,
  MinIndex: 0,
  MaxStep: 0,
  MaxIndex: 0,

  // remember essential data previous run:
  previousStepData: [],
  reloaded: true,

  // callbacks:
  out: { setIndex: null },

  openClose: function(instance) {
    for (var e = 0; e < WW.StepData.length; e++) {
      if (WW.StepData[e].instance == instance) {
        WW.StepData[e].open = ! WW.StepData[e].open;
      }
    }
    WW.updateAllHtml();
  },

  getStep: function(index) {
    var result = 0;
    for (var je = 0; je < WW.JsonSteps.length; je++) {
      if (WW.JsonSteps[je].selection
          && WW.JsonSteps[je].selection[0].index <= index) {
        result = je;
      }
    }
    return result;
  },

  setCurrent: function(index) {
    if (index < WW.MinIndex) index = WW.MinIndex;
    if (index > WW.MaxIndex) index = WW.MaxIndex;
    WW.currentStep = WW.getStep(index);
    WW.currentIndex = WW.JsonSteps[WW.currentStep].selection
      && WW.JsonSteps[WW.currentStep].selection[0].index;
  },

  initAdmin: function() {
    // pre: WW.JsonSteps starts with TraceType, followed by all init Steps
    WW.MaxStep = WW.JsonSteps.length-1;
    WW.MaxIndex = WW.JsonSteps.length>1 ? WW.JsonSteps[WW.JsonSteps.length-1].selection[0].index : 0;
    WW.MinStep = WW.MaxStep+1;
    WW.MinIndex = WW.MaxIndex+1;
    for (var je = 1; je < WW.JsonSteps.length; je++) {
      if (WW.JsonSteps[je].kind != 'Initialize') {
        WW.MinStep = je;
        WW.MinIndex = WW.JsonSteps[je].selection[0].index;
        break;
      }
    }
    WW.currentStep = WW.MinStep;
    WW.currentIndex = WW.MinIndex;
    WW.initTableData(WW.StepData);
  },

  initTableData: function(data) {
    function rank(role) {
      if (role == "interface") return 0;
      if (/provided/i.test(role)) return 1;
      if (role == "component") return 2;
      if (/required/i.test(role)) return 3;
    };
    var tabledata =
	WW.JsonSteps.filter(function(o) {return o.kind == "Initialize";})
	.sort(function(a,b) {return rank(a.role) - rank(b.role);});

    data.length = 0; // reset
    for (var je = 0; je < tabledata.length; je++) {
      data[je] = { instance: tabledata[je].instance, open: true, location: '', state: [] };
      var jstate = tabledata[je].state;
      for (var js = 0; js < jstate.length; js++) {
	data[je].state[js] =  { variable: jstate[js].variable, value: jstate[js].value, changed: true };
      }
    }
  },

  setTableData: function(data, jStep) { // TODO: INDEX??
    WW.initTableData(data);
    for (var je = WW.MinStep+1; je <= jStep; je++) {
      for (var e = 0; e < data.length; e++) {
        var TMP = WW.JsonSteps[je];
        if (data[e].instance == WW.JsonSteps[je].instance) {
          var loc = WW.JsonSteps[je].location;
          if (loc && loc.file && loc.begin && loc.begin.line) {
            data[e].location = loc.file.replace(/.*\//,'') + ":" + loc.begin.line;
          }
          var jstate = WW.JsonSteps[je].state;
          var state = [];
          for (var js = 0; js < jstate.length; js++) {
            state[js] = {variable: jstate[js].variable, value: jstate[js].value, changed: true };
          }
          data[e].state = state;
        }
      }
    }
  },

  fillDiff: function(newdata, olddata) {
    for (var e = 0; e < newdata.length; e++) {
      var newstate = newdata[e].state;
      if (e < olddata.length) {
        var oldstate = olddata[e].state;
        var match = true;
        for (var ns = 0; ns < newstate.length; ns++) {
          if (ns < oldstate.length) {
            match = match && (oldstate[ns].variable == newstate[ns].variable);
            if (match && oldstate[ns].value == newstate[ns].value) {
              newstate[ns].changed = false;
            }
            else {
              newstate[ns].changed = true;
            }
          }
        }
      }
    }
  },

  fillOpen: function(newdata, olddata) {
    for (var e = 0; e < newdata.length; e++) {
      if (e < olddata.length) {
        newdata[e].open = olddata[e].open;
      }
      else {
        newdata[e].open = true;
      }
    }
  },

  updateTableData: function(data, je) {
    var newdata = [];
    WW.setTableData(newdata, je);
    WW.fillDiff(newdata, data);
    WW.fillOpen(newdata, data);
    return newdata;
  },

  filter: function(steps) {
    return steps.filter(function(s,i,a) {
      return (
        s.kind != "GuardedStatement" &&
        s.kind != "OnEventStatement" &&
        s.kind != "ThreadEnter" &&
        s.kind != "ThreadExit" &&
        s.kind != "Dequeue" &&
	s.kind != "Block" &&
	s.kind != "Release"
      );
    });
  },

  gotoIndex: function(index) {
    WW.setCurrent(index);
    if (WW.reloaded) {
      WW.StepData = WW.updateTableData(WW.previousStepData, WW.currentStep);
    } else {
      WW.StepData = WW.updateTableData(WW.StepData, WW.currentStep);
    }
    WW.updateAllHtml();
    WW.reloaded = false;
  },

  draw: function(steps) {
    // deep copy:
    WW.previous = JSON.parse(JSON.stringify(WW.current || {}));
    WW.previousStepData = JSON.parse(JSON.stringify(WW.StepData || []));
    WW.reloaded = true;
    WW.JsonSteps = WW.filter(steps);
    WW.initAdmin();
    WW.updateAllHtml();
  },

  displayHtmlData: function(data) {
    var table = '';
    // skip "TraceType" entry
    for (var e = 0; e < data.length; e++) {
      var open = data[e].open ? '-' : '+';
      var row = '<tr>'
          + '<td class="WWopen" onclick=WW.openClose(\"' + data[e].instance + '\")>' + open + '</td>'
          + '<td class="WWinst">' + data[e].instance + '</td>'
          + '<td class="WWloc">' + data[e].location + '</td>'
          + '</tr>';
      table += row;
      if (data[e].open) {
        var state = data[e].state;
        var trigger_list;
        for (var s = 0; s < state.length; s++) {
          var row = '<tr>'
              + '<td class="WWopen"></td>'
              + '<td class="WWvar">' + state[s].variable + '</td>'
              + '<td class="WWval'+ (state[s].changed ? 'new' : 'old') + '">' + state[s].value + '</td>'
              + '</tr>';
          table += row;
        }
      }
    }
    return table;
  },

  updateAllHtml: function() {
    document.getElementById("WWTable").innerHTML =  WW.displayHtmlData(WW.StepData);
  }
}
