dzn = dzn || {}
dzn.view = dzn.view || {}

dzn.view.State_widget = function (locator, meta) {
  dzn.runtime.init (this, locator, meta);
  this._dzn.meta.ports = ['widget'];

  this.widget = new dzn.view.Iwidget({provides: {name: 'widget', component: this}, requires: {}});

  this.DIV = document.getElementById ('state');

  function instace_state2string(state) {
    return Object.keys(state).map(function(key) {
            return key + '=' + state[key];
    }).join(',\n-    ');
  };

  function state2string (state) {
    var instances = Object.keys(state);
    return instances
      .filter(function(i) {
        return state[i].state && Object.keys(state[i].state).length>0; })
      .map(function(i) {
        return i.split('.').filter(function(s) {return s != 'sut';}).join('.')
          + ':\n-    ' + instace_state2string(state[i].state);
      }).join('\n');
  };

  function state2array (state) {
    var instances = Object.keys(state);
    return instances
      .filter(function(i) {
        return state[i].state && Object.keys(state[i].state).length>0; })
      .map(function(i) {
        return { instance: i.split('.').filter(function(s) {return s != 'sut';}).join('.'),
                 kind: state[i].kind,
                 state: '-    ' + instace_state2string(state[i].state)
               };
      });
  };

  function event2string(event) {
    return event
      .filter(function(event) {
        return event.from.startsWith('<external>') || event.to.startsWith('<external>');
      })
      .map(function(event) {
        var p = (event.from.startsWith('<external>') ? event.from : event.to).split('.');
        p = (p.length == 2) ? p.slice(1) : p.slice(2);
        return p.join('.') + '.'+ event.name;
      })
      .join('\n');
  };

  function path(trail) {
    var prev = state_go.nodeDataArray[trail.toEdges[0].from];
    var prev_path = (prev.category == 'instance+state') ? [] : path(prev);
    return [trail].concat(prev_path);
  }

  state_go.out.initial_state = function() {
    return this.initial_state;
  }.bind(this);

  state_go.out.next_trails = function(state) {
    var trails = [];
    var tos = state.fromEdges.map(function(e) {return state_go.nodeDataArray[e.to]; });
    tos.forEach(function(to) {
      var to_tos = to.fromEdges.map(function(e) {return state_go.nodeDataArray[e.to]; });
      if (/*to_tos.length==1 && */to_tos[0].category=='instance+state') {
        if (to_tos.length != 1) {
          var debugging = 0; // TODO: why can this happen?
        }
        trails.push(path(to));
      } else
        trails = trails.concat(state_go.out.next_trails(to));
    });
    return trails;
  };

  state_go.out.next_states = function(state) {
    return state_go.out.next_trails(state).map(function(trail_path) {
      return state_go.nodeDataArray[trail_path[0].fromEdges[0].to];
    });
  };

  state_go.out.selected = function(state, event) {
    console.log ('state_go.out.selected: selection=%j,%j', state,event);
    if (event) {
      var div = document.getElementById('trace');
      if (div) {
        console.log ('focussing: %j', div);
        div.focus();
      }
      var sel = {selection: [{'instance+state': state.node, event: event}], origin: 'state'};
      this.widget.out.selected(sel);
    }
  }.bind(this);

  state_go.out.extend_trace = function(state1, event, state2) {
    console.log ('state_go.out.extend_trace: selection=%j, %j, %j', state1, event, state2);
    var selection = {selection: [{'instance+state': state1.node, event: event},
                                 {'instance+state': state2.node, event: []}],
                     origin: 'state'};
    console.log('selection: %j', selection);
    state_go.in.set_cursor('wait');
    this.widget.out.extend_trace(selection);
  }.bind(this);

  this.widget.in.init = function() {
    if (!this.DIV) return;
  };

  this.widget.in.notify = function(notification) {
    if (!this.DIV) return;
    console.log('State_widget.in.notify notification = %j', notification);
    if (notification.label == 'state')
      state_go.in.set_cursor('wait');
      this.widget.out.request(notification);
  };

  this.widget.in.draw = function(data) {
    if (!this.DIV) return;
    if (!data.state) return;

    console.log('State_widget.in.draw: data.state = %j', data.state);

    var nodes = Object.keys(data.state['node'])
        .map(function(key) {
          var node = data.state['node'][key];
          var ikey = parseInt(key);
          var result = {key: ikey,
                        node: node,
                        fromEdges: [],
                        toEdges: []
                       }
          if (ikey == 0) {
            result.category = 'start';
          } else {
            result.category = 'instance+state';
            result.content = state2array(node);
          }
          return result;
        });


    var horizon = false; //////////////////////////

    var links = data.state['link']
        .map(function(link) {
          return {from: link.from, to: link.to, event:link.event, text:event2string(link.event)};
        });

    function split_first(links) {
      // [link] -->  {event1:[link], event2:[link],...}
      // pre: all links have same link.from
      var result = {};
      links.forEach(function(link,index) {
        if (link.text == '') {
          result[index] = [link];
        } else {
          var split = link.text.split('\n');
          var first = split[0];
          if (!result[first]) result[first] = [];
          link.text = split.slice(1).join('\n');
          result[first].push(link);
        }
      });
      return result;
    }

    function isTree(key,value) {
      return isNaN(key);
    }

    function split_all(links) {
      // [link] -->  {event1:{event2: ..., ,,,}, ...}
      // pre: all links have same link.from
      var result = split_first(links);
      Object.keys(result).forEach(function(first) {
        if (isTree(first,result[first])) result[first] = split_all(result[first]);
        else result[first] = result[first][0];
      });
      return result;
    }

    function join_all(event_tree) {
      Object.keys(event_tree).forEach(function(event) {
        if (isNaN(event)) {
          var joined = join_all(event_tree[event]);
          if (Object.keys(joined).length==1) {
            var event2 = Object.keys(joined)[0];
            if (isNaN(event2)) {
              events = event + '\n' + event2;
              delete event_tree[event];
              event_tree[events] = joined[event2];
            } else {
              event_tree[event] = joined;
            }
          } else {
            event_tree[event] = joined;
          }
        }
      });
      return event_tree;
    }

    function split_from(links) {
      // [link] --> {from:[link]} where sublist shares link.from
      var result = {};
      links.forEach(function(link) {
        var from = link.from;
        if (!result[from]) result[from] = [];
        result[from].push(link);
      });
      return result;
    }

    function split(links) {
      var froms = split_from(links);
      Object.keys(froms).forEach(function(from) {
        froms[from] = split_all(froms[from]);
      });
      return froms;
    }

    var newlinks = [];
    var eventindex = nodes.length;

    function make_graph(from, event_tree) {
      Object.keys(event_tree).forEach(function(event) {
        var sub_tree = event_tree[event];
        if (isNaN(event)) {
          var index = eventindex++;
          var eventnode = {key: index,
                           event: {},
                           text: event,
                           category: 'event',
                           fromEdges: [],
                           toEdges: []
                          };
          nodes.push(eventnode);
          var edge = {from:from, to:index};
          newlinks.push(edge);
          nodes[from].fromEdges.push(edge);
          eventnode.toEdges.push(edge);
          make_graph(index, sub_tree);
        } else {
          var to = sub_tree.to;
          var edge = {from:from, to:to};
          newlinks.push(edge);
          nodes[from].fromEdges.push(edge);
          nodes[to].toEdges.push(edge);
          nodes[from].event = sub_tree.event;
        }
      });
    }

    var splitted = split(links);

    Object.keys(splitted).forEach(function(from) {
      var event_tree = splitted[from];
      var joined_tree = join_all(event_tree);
      make_graph(from,joined_tree);
    });

    var k = nodes.length;
    if (k>1) {
      var startEdge = {from: 0, to: 1};
      nodes[0].fromEdges.push(startEdge);
      nodes[1].toEdges.push(startEdge);
      newlinks.push(startEdge);
    }

    nodes.forEach( function (node) {
      node.visible = horizon ? false : true;
    });
    if (horizon) {
      nodes[0].visible = true;
      nodes[nodes.length-1].visible = true;
    }

    this.reuse_locations(nodes);

    var godata = {nodeDataArray: nodes, linkDataArray: newlinks};
    state_go.in.draw(godata);

    this.initial_state = false;
    state_go.in.set_cursor('');
  };

  this.widget.in.redraw = function() {
    if (!this.DIV) return;
    state_go.in.redraw();
    state_go.in.set_cursor('');
  };

  this.widget.in.go_to = function(selection) {
    if (!this.DIV) return;
    console.log('State_widget.in.go_to selection=%j', selection);

    if (selection.origin=='state' && selection.selection && !selection.selection[0].event) return;

    var transition = selection.selection[0];
    function object_subset(a, b) {
      if (typeof(a) !== 'object') return a == b;
      else if(Object.keys(a).length)
        return Object.keys(a).every(function(key) {
          return object_subset(a[key],b[key]);
        });
      else return Object.keys(b).length == 0;
    }

    var from_state = state_go.nodeDataArray.find (function (node) {
      return node.node && object_subset(node.node, transition['instance+state'], '    ');
    });

    if (!from_state) {
      console.log ('no from_state');
      return;
    }

    if (!transition.event.length) {
      var next_trails = state_go.out.next_trails(from_state);
      var next_states = state_go.out.next_states(from_state);
      state_go.in.go_to(from_state, [], null, next_trails, next_states);
    }
    else {
      var event_string = JSON.stringify(transition.event);
      var trail_path = state_go.out.next_trails(from_state)
          .find(function (n) { return JSON.stringify(n[0].event) == event_string; });
      var to_state = state_go.nodeDataArray[trail_path[0].fromEdges[0].to];
      var next_trails = state_go.out.next_trails(to_state);
      var next_states = state_go.out.next_states(to_state);
      state_go.in.go_to(from_state, trail_path, to_state, next_trails, next_states);
    }
    state_go.in.set_cursor('');
  };

  this.widget.in.go_to_instance = function(selection) {
    if (!this.DIV) return;
    console.log('State_widget.in.go_to_instance: selection=%j', selection);
    state_go.in.set_cursor('');
  };

  this.widget.in.clear = function() {
    if (!this.DIV) return;
    console.log('State_widget.in.clear');
    state_go.in.set_cursor('');
  };

  this.widget.in.select = function(pointer) {
    if (!this.DIV) return;
    console.log('State_widget.select');
    state_go.in.set_cursor('');
  };

  this.widget.in.stop = function() {
    if (!this.DIV) return;
    console.log('State_widget.in.stop');
    state_go.in.stop();
    state_go.in.set_cursor('');
  };

  this.reuse_locations = function(new_nodes) {
    var out_data = {};
    state_go.in.get_nodes(out_data);
    var old_nodes = out_data.value;
    if (!old_nodes) return;

    var nr_new_states = 0;
    var nr_new_events = 0;
    new_nodes.forEach(function(node) {
      if (node.category == 'instance+state') nr_new_states++;
      else if (node.category == 'event') nr_new_events++;
    });
    var nr_old_states = 0;
    var nr_old_events = 0;
    old_nodes.forEach(function(node) {
      if (node.category == 'instance+state') nr_old_states++;
      else if (node.category == 'event') nr_old_events++;
    });
    var is_extension =  old_nodes.length <= new_nodes.length;
    if (is_extension) {
      old_nodes.forEach(function(old_node) {
        if (old_node.category == 'start')
          new_nodes[old_node.key].loc = old_node.loc;
        else if (old_node.category == 'instance+state')
          new_nodes[old_node.key].loc = old_node.loc;
        else if (old_node.category == 'event')
          new_nodes[old_node.key+nr_new_states-nr_old_states].loc = old_node.loc;
      });
    }
    // locate additional nodes
    is_extension =  old_nodes.length < new_nodes.length;
    if (is_extension) {
      var eventnode = new_nodes[1+nr_new_states+nr_old_events];
      var statenode = new_nodes[eventnode.toEdges[0].from];
      new_nodes.forEach(function(new_node) {
        if (!new_node.loc) new_node.loc = statenode.loc;
    });
    }

  }

  if (!this.DIV) return;

  this.initial_state = true;
  state_go.in.init();

  this._dzn.rt.bind (this);
};

if (node_p ()) {
  // nodejs
  module.exports = dzn;
}

//code generator version: development
