if (!Array.prototype.append_map) {
  Array.prototype.append_map = function(lambda) {
    return [].concat.apply([], this.map(lambda));
  }
}

Array.prototype.rfind = function(pred) {
  for (var i = this.length-1; i>=0; i--) {
    if (pred(this[i])) return this[i];
  }
}

Array.prototype.eq = function(other) {
  return this.length == other.length && this.every(function(o, i) { return o == other[i]; });
}

// TODO: clean up meuk
var sign = function(n) {return n>0?1:n=0?0:-1;}

function is_index (i) {
  return function (o) {return o.selection && o.selection[0].index == i;}
}
function has_index (o) {
  return o && o.selection && (o.selection[0].index || o.selection[0].index === 0) && o;
}
function has_location (o) {
  return o && o.selection && o.selection[0].file && has_index (o) && o;
}

function is_cxx_simulator_not_skip (step) {
  return ['GuardedStatement','OnEventStatement','ThreadEnter','ThreadExit','Block','Release','Receive','Dequeue'].indexOf (step.kind) === -1;
}

function walk (trace, index, model, count) {
  var step = trace[index];
  if (!step || !step.selection || !step.selection[0].index) return has_location (step);
  if (typeof (model) === 'boolean') model = step.instance || model;
  index += sign (count);
  if (has_location (trace[index])
      && is_cxx_simulator_not_skip (trace[index])
      && (!model || (trace[index] && trace[index].instance === model)))
      return trace[index];
  return walk (trace, index, model, count);
}

firstWW = function() {};
nextWW = function() {};
stepWW = function() {};
backWW = function() {};
backstepWW = function() {};
lastWW = function() {};

dzn = dzn || {}
dzn.view = dzn.view || {}

dzn.view.Watch_widget = function(locator, meta) {
  dzn.runtime.init(this, locator, meta);
  this._dzn.meta.ports = ['widget'];

  this.widget = new dzn.view.Iwidget({provides: {name: 'widget', component: this}, requires: {}});
  this.DIV = document.getElementById ('watch');
    this.watch = null;
    this.trace = null;
    this.index = -1;

    firstWW = function() {
        var step = this.trace.find (has_location);
        this.index = step.selection[0].index;
        WW.out.setIndex(this.index);
    }.bind(this);

    nextWW = function() {
        stepWW(true);
    }.bind(this);

    stepWW = function(model) {
        var step = this.trace.find (is_index (this.index));
        var i = this.trace.indexOf (step);
        step = walk (this.trace, i, model, 1);
        if(has_index (step)) {
            this.index = step.selection[0].index;
            WW.out.setIndex(this.index);
        }
    }.bind(this);

    backWW = function() {
        backstepWW(true);
    }.bind(this);

    backstepWW = function(model) {
        var step = this.trace.find (is_index (this.index));
        var i = this.trace.indexOf (step);
        step = walk (this.trace, i, model, -1);
        if(has_index (step)) {
            this.index = step.selection[0].index;
            WW.out.setIndex(this.index);
        }
    }.bind(this);

    lastWW = function () {
        var step = this.trace.slice ().reverse ().find (has_location);
        this.index = step.selection[0].index;
        WW.out.setIndex(this.index);
    }.bind(this);

  WW.out.setIndex = function (index) {
    var selection = [{index:index}];
    this.widget.out.index_selected(selection);
  }.bind(this);


  this.widget.in.notify = function(notification) {
    if (!this.DIV) return;
    // if (notification.label == 'simulate')
//    watch_go.in.set_cursor('wait');
    this.widget.out.request({label:'simulate',origin:'watch'});
  };

  function depth(nodes) {
    var depth = 0;
    nodes.forEach(function(node) {
      var d = node.key.split('.').length - 1;
      if (d > depth) depth = d;
    });
    return depth;
  }

  this.widget.in.draw = function(data) {
    if (data.simulate) {
      data = data.simulate;
      data = JSON.parse(data);
      this.trace = data.seqdiag;
      WW.draw(data.seqdiag);
    }
  }

  this.widget.in.draw_system = function(data) {
    if (!this.DIV) return;
    console.log('watch widget draw: %j', data);
    if (!data.watch) return;

    var header = data.watch[0]['instance+state'];
    var keys = Object.keys(header);
    var header_nodes = keys
        .map(function(key) {
          var instance = header[key];
          ;; var composite = keys.find(function(k) { return k != key && k.startsWith(key); });
          var composite = instance.kind == 'system' || instance.kind == 'foreign' || instance.blackboxed;
          return {category: composite ? 'header_composite' : 'header_leaf',
                  key: 'H'+key,
                  model: instance.type,
                  kind: instance.blackboxed ? 'foreign' : instance.kind,
                  blackboxed: instance.blackboxed,
                  text: key.split('.').slice(-1)[0],
                  isGroup: true,
                  group: 'H' + (key.split('.').slice(0, -1).join('.') || '-top-'),
                  expanded: true
                 };
        });
    header_nodes = header_nodes
        .filter(function(node) {
          if (node.kind !== 'provides' && node.kind !== 'requires') return true;
          var container = header_nodes.find(function(n) { return n.key == node.group; });
          return !container || container.kind == 'foreign';
        });


    function port2key(port) {
      var a = port.split('.');
      return a[0] == '<external>' ?  a.slice(1).join('.') : a.slice(0,-1).join('.');
    }

    var lifeline_nodes = header_nodes
        .map(function(header) {
          return {category: header.category=='header_composite' ? 'lifeline_composite' : 'lifeline_leaf',
                  key: 'L'+header.key.slice(1),
                  model: header.model,
                  kind: header.kind,
                  text: '',
                  isGroup: true,
                  group: 'L'+header.group.slice(1),
                  expanded: true
                 };
        });

    var timeoffset = depth(header_nodes)*4; // FIXME: better heuristic
    var index = 0;
    var block_nodes = [];
    var blocks = data.watch
        .map(function(transition) {
          var links = transition.event.map(function(event) {
            var i = index++;
            var from_text = event.from.split('.').slice(-1)[0];
            if (from_text == '<q>') from_text = '';
            return {category: 'link',
                    index: 'L' + i,
                    kind: (event.name == 'return') ? 'return' : 'call',
                    from: 'L' + port2key(event.from),
                    from_text: from_text,
                    to: 'L' + port2key(event.to),
                    to_text: event.to.split('.').slice(-1)[0],
                    text: event.name,
                    time: timeoffset+i,
                    event: event
                   };
          });
          var duration = links.length;
          var blocknode;
          if (duration) {
            var time = links[0].time;
            var i = links.length ? links[0].index : 0;
            blocknode = {category: 'lifeline_block',
                         key: 'B'+index,
                         group: '-top-',
                         duration: duration,
                         time: time};
            block_nodes.push(blocknode);
          }
          return {links:links, blocknode: blocknode, transition: transition};
        });

    var links = blocks.append_map(function(block) { return block.links; });
    //nodes=used_nodes(nodes,links);

    function complete(header_nodes, lifeline_nodes, links) {
      function avarage_index(node) {
        var subs = header_nodes.filter(function(n) {return n.group == node.key; });
        if (subs.length==0) return 1.0*node.index;
        var tot = 0;
        subs.forEach(function(sub) {
          tot += avarage_index(sub);
        });
        return tot / subs.length;
      }

      var xsep = 120;
      var ysep = 40;
      var yoffset = 70;
      var index = 0;
      header_nodes.forEach(function(node) {
        var subs = header_nodes.filter(function(n) {return n.group == node.key; });
        if (subs.length == 0) {
          index++;
          node.index = index;
        } else {
          node.index = 0;
        }
      });

      var d = depth(header_nodes);

      header_nodes.forEach(function(node) {
        if (node.category != 'lifeline_block') {
          node.loc = '' + (avarage_index(node) * xsep) + ' ' + (yoffset + (d*ysep));
          node.duration = duration;
        }
      });

      var duration = timeoffset + links.length;
      //  console.error('depth = %j; initial_time = %j;#links = %j', d, initial_time(header_nodes), links.length);
      lifeline_nodes.forEach(function(node) {
        var header = header_nodes.find(function(h) { return node.key == 'L'+h.key.slice(1); });
        node.index = header.index
        node.duration = duration;
        var location = header.loc.split(' ');
        node.loc = location[0] + ' ' + (yoffset + (d*ysep));
      });
    }

    complete(header_nodes, lifeline_nodes, links);

    var min = 10000;
    lifeline_nodes.forEach(function(n) {
      min = Math.min(min, n.loc.split(' ')[0]);
    });
    var header_top = {category:'header_top', key:'H-top-', isGroup:true, group:'-top-', loc: ''+min+' 0'};
    header_nodes.push(header_top);
    var top = {category:'top', key:'-top-', isGroup:true, loc: ''+min+' 0'};
    lifeline_nodes.push(top);

    var nodes = header_nodes.concat(lifeline_nodes, block_nodes);
    this.watch = {blocks:blocks, nodeDataArray:nodes, linkDataArray:links};

    console.log('watch: %j',this.watch);
//    watch_go.in.draw(this.watch);
    if (this.watch.blocks.length > 1) {
      var links = this.watch.blocks[this.watch.blocks.length-2].links;
      var blocknode = this.watch.blocks[this.watch.blocks.length-2].blocknode;
//      watch_go.in.go_to(links, blocknode);
    } else {
//      watch_go.in.go_to([], null);
    }
//    watch_go.in.set_cursor('');
  };

  this.widget.in.redraw = function() {
    if (!this.DIV) return;
//    watch_go.in.redraw();
//    watch_go.in.set_cursor('');
  };

  this.widget.in.go_to = function(selection) {
  };

  this.widget.in.go_to_index = function(selection) {
    WW.gotoIndex(selection[0].index);
  };

  this.widget.in.go_to_instance = function(selection){
  };

  this.widget.in.clear = function(){
    if (!this.DIV) return;
    console.log('Watch_widget.in.clear');
//    watch_go.in.set_cursor('');
  };

  this.widget.in.select = function(pointer){
    if (!this.DIV) return;
    console.log('Watch_widget.in.select');
  };

  this.widget.in.stop = function() {
    if (!this.DIV) return;
    console.log('Watch_widget.in.stop');
//    watch_go.in.stop();
//    watch_go.in.set_cursor('');
  };

  this._dzn.rt.bind(this);
};

if (node_p()) {
  // nodejs
  module.exports = dzn;
}

//code generator version: development
