;;; dzn-ls.el -- Language Server support for Dezyne.
;;;
;;; Dezyne-IDE --- An IDE for Dezyne
;;; Copyright © 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2020 Rutger van Beusekom <rutger.van.beusekom@verum.com>
;;; Copyright © 2020 Johri van Eerd <johri.van.eerd@verum.com>
;;;
;;; This file is part of Dezyne-IDE.
;;;
;;; Dezyne-IDE is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; Dezyne-IDE is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with Dezyne-IDE.  If not, see <http://www.gnu.org/licenses/>.

;;; Commentary:

;; Installation
;;
;; * Install the websocket package
;;
;;   select: Options/Manage Emacs Packages, or M-x list-packages
;;
;; * Optionally, install the lsp-mode package
;;
;;   select: Options/Manage Emacs Packages, or M-x list-packages
;;
;; * Add to your ~/.config/emacs/init.el
;;
;;   (when (require 'dzn-mode nil t)
;;     (push '("\\.dzn\\'" . dzn-mode) auto-mode-alist))
;;
;; * Evaluate ~/.config/emacs/init.el or restart Emacs

;;; Code:

(require 'dzn-ide) ;for ide-program, see also pre-inst-env.el
(require 'lsp-mode)

;; FIXME: before require'ing LSP??
(setq lsp-keymap-prefix "C-l")
(setq lsp-log-io t)
(setq lsp-print-io t)

(defcustom lsp-clients-dzn-server-command `(,@(split-string ide-program " ") "lsp")
  "Command to start dzn lsp.")

(lsp-register-client
 (make-lsp-client :new-connection
		  (lsp-stdio-connection
                   (lambda () lsp-clients-dzn-server-command))
                  :major-modes '(dzn-mode)
                  :priority -1
                  :server-id 'dzn-ls))

(add-hook 'dzn-mode-hook #'lsp-deferred)
(add-to-list 'lsp-language-id-configuration '(dzn-mode . "Dezyne"))

(provide 'dzn-ls)
;;; dzn-ls.el ends here
