(define-module (daemon Routing)
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:use-module (daemon daemon_interface)
  #:use-module (transport libenvelope)
  #:duplicates (merge-generics)
  #:export (<daemon:Routing>
            .routing))

(define-class <daemon:Routing> (<dzn:component>)
  (routing #:accessor .routing #:init-form (make <daemon:Irouting>) #:init-keyword #:routing))

(define-method (initialize (o <daemon:Routing>) args)
  (next-method)
  (set! (.routing o)
        (make <daemon:Irouting>
          #:in (make <daemon:Irouting.in>
                 #:name "routing"
                 #:self o
                 #:storedata2viewlabel (lambda args (call-in o (lambda _ (apply routing-storedata2viewlabel (cons o args))) `(,(.routing o) storedata2viewlabel)))
                 #:storedata2viewdata (lambda args (call-in o (lambda _ (apply routing-storedata2viewdata (cons o args))) `(,(.routing o) storedata2viewdata)))
                 #:viewlabel2storelabel (lambda args (call-in o (lambda _ (apply routing-viewlabel2storelabel (cons o args))) `(,(.routing o) viewlabel2storelabel))))

          #:out (make <daemon:Irouting.out>))))

(define label->view
  `((command . command)
    (hello . hello)
    (parse . system)
    (state . state)
    (step . trace)
    (verify . verify)
    (lseligible . lseligible)
    (seqdiag . seqdiag)
    (simulate . simulate)))

(define-method (routing-storedata2viewlabel (o <daemon:Routing>) data out-label)
  (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug)))
    (log-debug "routing-storedata2viewlabel data:~s\n" data))
  (let ((view (assoc-ref label->view (libenvelope:label data))))
    (set-cdr! out-label `(("label" . ,view)))))

(define-method (routing-storedata2viewdata (o <daemon:Routing>) data out-data)
  (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug)))
    (log-debug "routing-storedata2viewdata data:~s\n" data))
  (let ((view (assoc-ref label->view (libenvelope:label data))))
    (set-cdr! out-data (libenvelope:wrap view (libenvelope:data data)))))

(define (assoc-xref alist value)
  (define (cdr-equal? x) (equal? (cdr x) value))
  (and=> ((@ (srfi srfi-1) find) cdr-equal? alist) car))

(define-method (routing-viewlabel2storelabel (o <daemon:Routing>) in-label out-label)
  (let ((log-debug (dzn:get (.locator o) <procedure> 'log-debug)))
    (log-debug "routing-viewlabel2storelabel label:~s\n" in-label))
  (let* ((label (assoc-ref in-label "label"))
         (label (string->symbol label))
         (store-label (assoc-xref label->view label))
         (origin (assoc-ref in-label "origin"))
         (store-origin (string->symbol origin)))
    (set-cdr! out-label `(("label" . ,store-label)
                          ("origin" . ,store-origin)))))
