;;; Dezyne --- Dezyne command line tools
;;;
;;; Copyright © 2017, 2018, 2019, 2020 Jan Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2018 Rutger van Beusekom <rutger.van.beusekom@verum.com>
;;;
;;; This file is part of Dezyne.
;;;
;;; Dezyne is free software: you can redistribute it and/or modify it
;;; under the terms of the GNU Affero General Public License as
;;; published by the Free Software Foundation, either version 3 of the
;;; License, or (at your option) any later version.
;;;
;;; Dezyne is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; Affero General Public License for more details.
;;;
;;; You should have received a copy of the GNU Affero General Public
;;; License along with Dezyne.  If not, see <http://www.gnu.org/licenses/>.
;;;
;;; Commentary:
;;;
;;; Compile-time configuration of gaiag.  When adding a substitution
;;; variable here, make sure to have configure substitute it.
;;;
;;; Code:

(define-module (gaiag config)
  #:export (%bindir
            %datadir
            %datarootdir
            %dzn
            %guilemoduledir
            %guileobjectdir
            %default-languages
            %package
            %prefix
            %template-dir
            %version
            %version-major
            %version-minor
            %version-patch))

(define %package
  (or (and (getenv "DZN_UNINSTALLED") "dezyne")
      "dezyne"))

(define %prefix
  (or (and (getenv "DZN_UNINSTALLED") (getenv "DZN_PREFIX"))
      "/gnu/store/1nc1jrci1bnmxry7izlnf6fb9hpwb57f-dezyne-mingw-2.11.0"))

(define %datadir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      "/gnu/store/1nc1jrci1bnmxry7izlnf6fb9hpwb57f-dezyne-mingw-2.11.0/share"))

(define %datarootdir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      "/gnu/store/1nc1jrci1bnmxry7izlnf6fb9hpwb57f-dezyne-mingw-2.11.0/share"))

(define %pkgdatadir
  (or (and (getenv "DZN_UNINSTALLED") %prefix)
      (getenv "DZN_DATADIR")
      (string-append %datadir "/" %package)))

(define %bindir
  (or (and (getenv "DZN_UNINSTALLED") (string-append %prefix "/bin"))
      "/gnu/store/1nc1jrci1bnmxry7izlnf6fb9hpwb57f-dezyne-mingw-2.11.0/bin"))

(define %template-dir
  (string-append %datadir "/templates"))

(define %guilemoduledir
  "/gnu/store/1nc1jrci1bnmxry7izlnf6fb9hpwb57f-dezyne-mingw-2.11.0/share/guile/site/2.2")

(define %guileobjectdir
  "/gnu/store/1nc1jrci1bnmxry7izlnf6fb9hpwb57f-dezyne-mingw-2.11.0/lib/guile/2.2/site-ccache")

(define %version
  "2.11.0")

(define %version-major
  2)

(define %version-minor
  11)

(define %version-patch
  0)

(define %dzn
  (string-append %bindir "/dzn"))

(define %default-languages
  (string-split (string-trim-both "c++") #\space))
