(define-module (ide command-line)
  #:use-module (srfi srfi-1)
  #:use-module (ice-9 getopt-long)
  #:use-module (ide script)
  #:export (command-line:get
            command-line:debugity
            command-line:verbosity
            ide:command-line:get
            ide:debugity
            ide:multi-opt
            ide:verbosity
            multi-opt
            EXIT_OTHER_FAILURE))

(define EXIT_OTHER_FAILURE 2)

(define multi-options
  '(import))

(define* (command-line:get option #:optional default #:key (multi-options multi-options))
  (and (> (length (command-line)) 1)
       (let* ((files (option-ref (parse-opts (command-line)) '() '(#f)))
              (file (car files))
              (command (string->symbol file))
              (parse-opts (let ((module (resolve-module `(ide commands ,command))))
                            (module-ref module 'parse-opts)))
              (options (if command (parse-opts files)
                           (parse-opts (command-line))))
              (multi-opt (lambda (option) (lambda (o) (and (eq? (car o) option) (cdr o))))))
         (if (not (member option multi-options)) (option-ref options option default)
             (filter-map (multi-opt option) options)))))

(define* (ide:command-line:get option #:optional default)
  (and (> (length (command-line)) 1)
       (let ((options (parse-opts (command-line))))
         (option-ref options option default))))

(define (multi-opt options name)
  (let ((opt? (lambda (o) (and (eq? (car o) name) (cdr o)))))
    (filter-map opt? options)))

(define (ide:multi-opt name)
  (or (and (> (length (command-line)) 1)
           (multi-opt (parse-opts (command-line)) name))
      '()))

(define (ide:debugity)
  (or (and (pair? (command-line))
           (member ((compose basename car command-line))
                   '("dzn" ".dzn-real" "ide" ".ide-real"))
           (and=> (ide:multi-opt 'debug) length))
      0))

(define (command-line:debugity)
  (or (and=> (false-if-exception
              (command-line:get 'debug #:multi-options '(debug))) length)
      0))

(define (ide:verbosity)
  (or (and (pair? (command-line))
           (member ((compose basename car command-line))
                   '("dzn" ".dzn-real" "ide" ".ide-real"))
           (length (ide:multi-opt 'verbose)))
      0))

(define (command-line:verbosity)
  (or (and=> (false-if-exception
              (command-line:get 'verbose #:multi-options '(verbose))) length)
      0))
