(define-module (ide config)
  #:export (%datadir
            %datarootdir
            %daemon-config-file
            %default-editor-port
            %default-http-port
            %default-ide-port
            %default-view-port
            %editor-port
            %http-port
            %ide-port
            %imports
            %pkgdatadir
            %prefix
            %user-cache-dir
            %user-config-dir
            %user-runtime-dir
            %version
            %view-port
            %web-root))

(define %imports
  '())

(define %prefix
  (or (and (getenv "IDE_UNINSTALLED") (getenv "IDE_PREFIX"))
      "/gnu/store/h0cv6qq1ldvvydq3w4n4xlr447jlww4q-dezyne-ide-mingw-2.11.0"))

(define %datadir
  (or (and (getenv "IDE_UNINSTALLED") %prefix)
      "/gnu/store/h0cv6qq1ldvvydq3w4n4xlr447jlww4q-dezyne-ide-mingw-2.11.0/share"))

(define %datarootdir
  (or (and (getenv "IDE_UNINSTALLED") %prefix)
      "/gnu/store/h0cv6qq1ldvvydq3w4n4xlr447jlww4q-dezyne-ide-mingw-2.11.0/share"))

(define %pkgdatadir
  (or (and (getenv "IDE_UNINSTALLED") %prefix)
      (getenv "IDE_DATADIR")
      "/gnu/store/h0cv6qq1ldvvydq3w4n4xlr447jlww4q-dezyne-ide-mingw-2.11.0/share/dezyne-ide"))

(define %user-cache-dir
  (string-append (or (getenv "XDG_CACHE_HOME")
                     (string-append (getenv "HOME") "/.cache"))
                 "/dzn"))

(define %user-config-dir
  (string-append (or (getenv "XDG_CONFIG_HOME")
                     (string-append (getenv "HOME") "/.config"))
                 "/dzn"))

(define %user-runtime-dir
  (string-append (or (getenv "XDG_RUNTIME_DIR")
                     (and (defined? 'getuid)
                          (let ((dir (format #f "/run/user/~s" (getuid))))
                            (and (file-exists? dir)
                                 dir)))
                     (getenv "XDG_CACHE_HOME")
                     (string-append (getenv "HOME") "/.cache"))
                 "/dzn"))

(define %daemon-config-file
  (string-append %user-config-dir "/daemon.scm"))

(define %web-root
  (string-append %pkgdatadir "/dzn"))

(define %version
  "2.11.0")

(define %default-editor-port
  3003)

(define %default-http-port
  3000)

(define %default-ide-port
  3001)

(define %default-view-port
  3002)

(define %editor-port
  3003)

(define %http-port
  3000)

(define %ide-port
  3001)

(define %view-port
  3002)
