(define-module (ide disable-imports)
  #:use-module (ice-9 regex)
  #:export (disable-imports))

(define (disable-imports content)
  "Comment all occurences of 'import' for seqdiag; the old parser also
exports imports in a preprocessed file (stream)."
  (regexp-substitute/global #f
                            "(^|\n)(import )"
                            content
                            'pre
                            (lambda (m)
                              (string-append
                               (match:substring m 1)
                               "// disabled "
                               (match:substring m 2)))
                            'post))
