(define-module (ide util)
  #:use-module (ide config)
  #:use-module (ide command-line)
  #:export (get-url
            log-debug
            log-error
            log-format
            log-trace
            log-verbose))

(define (get-url what)
  (let* ((ports `(,@(if (equal? %view-port %default-view-port) '()
                        (list (format #f "port=~a" %view-port)))
                  ,@(if (equal? %http-port %default-http-port) '()
                        (list (format #f "http=~a" %http-port)))))
         (params (if (null? ports) ""
                     (string-append "?" (string-join ports "&"))))
         (host (format #f "http://localhost:~a" %http-port)))
    (cond ((member what '("simulate" "trace" "verify"))
           (string-append host "/trace" params))
          ((equal? what "watch")
           (string-append host "/watch" params))
          ((member what '("parse" "system"))
           (string-append host "/system" params))
          (else ""))))

(define* (truncate-string string #:key (length
                                        (or (and=> (getenv "COLUMNS") string->number)
                                            80)))
  (if (< (string-length string) length) string
      (let ((newline? (string-suffix? "\n" string)))
        (string-append (string-take string (- length 3 (if newline? 1 0)))
                       "..."
                       (if newline? "\n" "")))))

(define (log-format port string . rest)
  (let ((time (strftime "%Y-%m-%d %T" (localtime (current-time)))))
    (apply format port (string-append "~a " string) time rest)))

(define (log-debug string . rest)
  (let ((debugity (+ (ide:debugity) (command-line:debugity))))
   (when (> debugity 1)
     (let* ((message (apply format #f string rest))
            (message (if (> debugity 2) message
                         (truncate-string message))))
       (display message (current-error-port))))))

(define (log-error string . rest)
  (apply log-format (current-error-port) string rest))

(define (log-verbose string . rest)
  (let ((debugity (+ (ide:debugity) (command-line:debugity)))
        (verbosity (+ (ide:verbosity) (command-line:verbosity))))
    (when (or (> debugity 0) (> verbosity 0))
      (let* ((message (apply log-format #f string rest))
             (message (if (> debugity 2) message
                          (truncate-string message))))
        (display message (current-error-port))))))

(define* (log-trace string . rest)
  (let ((debugity (+ (ide:debugity) (command-line:debugity))))
    (when (> debugity 1)
      (apply format (current-error-port) string rest))))
