(define-module (transport transport_interface)
  #:use-module (oop goops)
  #:use-module (dzn runtime)

  #:duplicates (merge-generics)
  #:export (<transport:Iserialize>
    <transport:Iserialize.in>
    <transport:Iserialize.out>
    .pack
    .message
    .unpack
    .data
    .ping
    .pong
    <transport:Iwebsocket>
    <transport:Iwebsocket.in>
    <transport:Iwebsocket.out>
    .listen
    .open
    .close
    .send
    .get
    .listening
    .connected
    .error
    .disconnect)
)

(define true #t)
(define false #f)





(define transport:Iserialize:STATE:alist
  '((IDLE . STATE_IDLE)
    (PACK . STATE_PACK)
    (UNPACK . STATE_UNPACK)
    (PING . STATE_PING)))

(define-class <transport:Iserialize.in> (<dzn:port>)
  (pack #:accessor .pack #:init-keyword #:pack)

  (unpack #:accessor .unpack #:init-keyword #:unpack)

  (ping #:accessor .ping #:init-keyword #:ping)

)

(define-class <transport:Iserialize.out> (<dzn:port>)
  (message #:accessor .message #:init-keyword #:message)

  (data #:accessor .data #:init-keyword #:data)

  (pong #:accessor .pong #:init-keyword #:pong)

)

(define-class <transport:Iserialize> (<dzn:interface>)
)
(define transport:Iwebsocket:State:alist
  '((Closed . State_Closed)
    (Opening . State_Opening)
    (Open . State_Open)
    (Closing . State_Closing)))

(define-class <transport:Iwebsocket.in> (<dzn:port>)
  (listen #:accessor .listen #:init-keyword #:listen)

  (open #:accessor .open #:init-keyword #:open)

  (close #:accessor .close #:init-keyword #:close)

  (send #:accessor .send #:init-keyword #:send)

  (get #:accessor .get #:init-keyword #:get)

)

(define-class <transport:Iwebsocket.out> (<dzn:port>)
  (listening #:accessor .listening #:init-keyword #:listening)

  (connected #:accessor .connected #:init-keyword #:connected)

  (error #:accessor .error #:init-keyword #:error)

  (message #:accessor .message #:init-keyword #:message)

  (disconnect #:accessor .disconnect #:init-keyword #:disconnect)

)

(define-class <transport:Iwebsocket> (<dzn:interface>)
)

;; code generator version: 0.0.0
