// Dezyne-IDE --- An IDE for Dezyne
//
// Copyright © 2019,2020 Rob Wieringa <Rob.Wieringa@verum.com>
//
// This file is part of Dezyne-IDE.
//
// Dezyne-IDE is property of Verum Software Tools BV <support@verum.com>.
// All rights reserved.

function node_p () {return typeof module !== 'undefined';}

var ast = {

  klass: function (o) {
    if (typeof (o) == 'object') {
      return o['<class>'];
    }
  }
  ,
  is_a: function (o, cls) {
    return typeof (o) == 'object' && ast.klass(o) == cls;
  }
  ,
  is_p: function (cls) {
    return function (o) {
      return ast.is_a(o, cls);
    };
  }
  ,
  field_eq_p: function(field, value) {
    return function (o) {
      return o[field] == value;
    };
  }
  ,
};

if (node_p ()) {
  module.exports = ast;
}
