// Dezyne-IDE --- An IDE for Dezyne
//
// Copyright © 2020 Rob Wieringa <Rob.Wieringa@verum.com>
// Copyright © 2020 Jan (janneke) Nieuwenhuizen <janneke@gnu.org>
//
// This file is part of Dezyne-IDE.
//
// Dezyne-IDE is property of Verum Software Tools BV <support@verum.com>.
// All rights reserved.

if (!Array.prototype.append_map) {
  Array.prototype.append_map = function(lambda) {
    return [].concat.apply([], this.map(lambda));
  }
}

Array.prototype.rfind = function(pred) {
  for (var i = this.length-1; i>=0; i--) {
    if (pred(this[i])) return this[i];
  }
}

Array.prototype.eq = function(other) {
  return this.length == other.length && this.every(function(o, i) { return o == other[i]; });
}

dzn = dzn || {}
dzn.view = dzn.view || {}

dzn.view.Trace_widget = function(locator, meta) {
  dzn.runtime.init(this, locator, meta);
  this._dzn.meta.ports = ['widget'];
  this.origin = 'trace';

  this.widget = new dzn.view.Iwidget({provides: {name: 'widget', component: this}, requires: {}});
  this.DIV = document.getElementById (this.origin);
  this.trace = null;
  this.data = null;

  this.select_block = function(blockIndex) {
    console.log('select_block: blockIndex: %s', blockIndex);

    if (-1 < blockIndex && blockIndex < this.trace.blocks.length - 1) {
      var block = this.trace.blocks[blockIndex];
      var transition = block.transition;
      var selection = {selection: [transition], origin: 'trace'};
      this.widget.out.selected(selection);
      //SeqDiag.in.go_to(block.links, block.blocknode);
    }
  }.bind(this);

  SeqDiag.out.setIndex = function (index) {
    // TODO: have editor connect to %view-port and talk with to Editor_widget.js

    // var ws = new WebSocket('ws://127.0.0.1:' + global_http_port);
    // ws.onopen = function() {ws.send (JSON.stringify(this.data_simulate.seqdiag[index].selection));}.bind(this);
    // ws.onmessage = function() { ws.close(); };

    var selection = [{index:index}];
    this.widget.out.index_selected(selection);
  }.bind(this);


  SeqDiag.out.handleEligible = function (eligible) {
    console.log('-------------- eligible: %s', eligible);
    if (eligible == '--back--') {
      this.widget.out.backintrace();
    } else {
      this.widget.out.eligible(eligible);
    }
  }.bind(this);


  this.widget.in.notify = function(notification) {
    if (!this.DIV) return;
    // if (notification.label == 'trace')
//    SeqDiag.in.set_cursor('wait');
    this.widget.out.request({label:'trace',origin:'trace'});
  }.bind(this);

  function depth(nodes) {
    var depth = 0;
    nodes.forEach(function(node) {
      var d = node.key.split('.').length - 1;
      if (d > depth) depth = d;
    });
    return depth;
  }

  this.widget.in.draw = function(data) {
    if (data.trace) {
      data = data.trace;
      data = JSON.parse(data);
      SeqDiag.in.draw(trace2seq(data));
    }
  }.bind(this);

  this.widget.in.redraw = function() {
    if (!this.DIV) return;
    SeqDiag.in.redraw();
    SeqDiag.in.set_cursor('');
  };

  this.widget.in.go_to = function(selection) {
    if (!this.DIV) return;
    if (selection.origin == 'trace') return;
    console.log('trace selection: %j', selection);

    if (!this.trace) return;
    var selection_string = JSON.stringify(selection.selection[0]);
    var block = this.trace.blocks
        .rfind(function(block) {
          return selection_string == JSON.stringify(block.transition);
        }.bind(this));
    if (block) SeqDiag.in.go_to(block.links, block.blocknode);
    else SeqDiag.in.go_to([], null);
    SeqDiag.in.set_cursor('');
  };

  this.widget.in.go_to_index = function(selection) {
    SeqDiag.in.gotoIndex(selection[0].index);
  };

  this.widget.in.go_to_instance = function(selection){
    if (!this.DIV) return;
    //console.log('Trace_widget.go_to_instance: selection=%j', selection);
    SeqDiag.in.go_to_instance(selection);
    SeqDiag.in.set_cursor('');
  };

  this.widget.in.clear = function(){
    if (!this.DIV) return;
    console.log('Trace_widget.in.clear');
    SeqDiag.in.set_cursor('');
  };

  this.widget.in.select = function(pointer){
    if (!this.DIV) return;
    console.log('Trace_widget.in.select');
  };

  this.widget.in.stop = function() {
    if (!this.DIV) return;
    console.log('Trace_widget.in.stop');
    //SeqDiag.in.stop();
    //SeqDiag.in.set_cursor('');
  };

  this.widget.in.origin = function() {
    this.widget.out.origin_label({label:this.origin,origin:this.origin});
  }

//  if (!this.DIV) return;

  SeqDiag.init('trace');

  this._dzn.rt.bind(this);
};

if (node_p()) {
  // nodejs
  module.exports = dzn;
}

//code generator version: development
