;;; Generated by dzn code from dzn/transport/transport_interface.dzn
;;; Verum-Dezyne --- An IDE for Dezyne
;;;
;;; Copyright © 2019 Rob Wieringa <Rob.Wieringa@verum.com>
;;; Copyright © 2020 Paul Hoogendijk <paul.hoogendijk@verum.com>
;;;
;;; This file is part of Verum-Dezyne.
;;;
;;; Verum-Dezyne is property of Verum Software Tools BV <support@verum.com>.
;;; All rights reserved.
;;; Copyright © 2017 Jan Nieuwenhuizen <janneke@gnu.org>
;;; This file is part of dzn.websocket
;;; dzn.websocket is free software; you can redistribute it and/or
;;; modify it under the terms of the GNU General Public License as
;;; published by the Free Software Foundation; either version 3 of the
;;; License, or (at your option) any later version.
;;; dzn.websocket is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
;;; General Public License for more details.
;;; You should have received a copy of the GNU General Public License
;;; along with dzn.websocket.  If not, see
;;; <http://www.gnu.org/licenses/>.
;;;
(define-module (transport transport_interface)
  #:use-module ((ice-9 control) #:select (let/ec))
  #:use-module (oop goops)
  #:use-module (dzn runtime)
  #:duplicates (merge-generics)
  #:export (<transport:Iserialize>
    <transport:Iserialize.in>
    <transport:Iserialize.out>
    .pack
    .message
    .unpack
    .data
    .ping
    .pong
    <transport:Iwebsocket>
    <transport:Iwebsocket.in>
    <transport:Iwebsocket.out>
    .listen
    .open
    .close
    .send
    .get
    .listening
    .connected
    .error
    .disconnect))

(define true #t)
(define false #f)

(define transport:Iserialize:STATE:alist
  '((IDLE . STATE:IDLE)
    (PACK . STATE:PACK)
    (UNPACK . STATE:UNPACK)
    (PING . STATE:PING)))
(define-class <transport:Iserialize.in> (<dzn:port>)
  (pack #:accessor .pack #:init-keyword #:pack)
  (unpack #:accessor .unpack #:init-keyword #:unpack)
  (ping #:accessor .ping #:init-keyword #:ping))

(define-class <transport:Iserialize.out> (<dzn:port>)
  (message #:accessor .message #:init-keyword #:message)
  (data #:accessor .data #:init-keyword #:data)
  (pong #:accessor .pong #:init-keyword #:pong))

(define-class <transport:Iserialize> (<dzn:interface>))

(define transport:Iwebsocket:State:alist
  '((Closed . State:Closed)
    (Opening . State:Opening)
    (Open . State:Open)
    (Closing . State:Closing)))
(define-class <transport:Iwebsocket.in> (<dzn:port>)
  (listen #:accessor .listen #:init-keyword #:listen)
  (open #:accessor .open #:init-keyword #:open)
  (close #:accessor .close #:init-keyword #:close)
  (send #:accessor .send #:init-keyword #:send)
  (get #:accessor .get #:init-keyword #:get))

(define-class <transport:Iwebsocket.out> (<dzn:port>)
  (listening #:accessor .listening #:init-keyword #:listening)
  (connected #:accessor .connected #:init-keyword #:connected)
  (error #:accessor .error #:init-keyword #:error)
  (message #:accessor .message #:init-keyword #:message)
  (disconnect #:accessor .disconnect #:init-keyword #:disconnect))

(define-class <transport:Iwebsocket> (<dzn:interface>))
;;; version: 2.17.0.rc0
